rule win_sysraw_stealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.sysraw_stealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.sysraw_stealer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffd3 8bd0 8d8decfeffff ffd6 8b4d90 8d9580feffff 83c114 }
            // n = 7, score = 700
            //   ffd3                 | call                ebx
            //   8bd0                 | mov                 edx, eax
            //   8d8decfeffff         | lea                 ecx, [ebp - 0x114]
            //   ffd6                 | call                esi
            //   8b4d90               | mov                 ecx, dword ptr [ebp - 0x70]
            //   8d9580feffff         | lea                 edx, [ebp - 0x180]
            //   83c114               | add                 ecx, 0x14

        $sequence_1 = { 56 ff512c 8b55bc 8b06 8d8d54feffff }
            // n = 5, score = 700
            //   56                   | push                esi
            //   ff512c               | call                dword ptr [ecx + 0x2c]
            //   8b55bc               | mov                 edx, dword ptr [ebp - 0x44]
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   8d8d54feffff         | lea                 ecx, [ebp - 0x1ac]

        $sequence_2 = { 33c9 8955bc 894de4 ba3f000000 }
            // n = 4, score = 700
            //   33c9                 | xor                 ecx, ecx
            //   8955bc               | mov                 dword ptr [ebp - 0x44], edx
            //   894de4               | mov                 dword ptr [ebp - 0x1c], ecx
            //   ba3f000000           | mov                 edx, 0x3f

        $sequence_3 = { 6a0d 57 56 ff5238 }
            // n = 4, score = 700
            //   6a0d                 | push                0xd
            //   57                   | push                edi
            //   56                   | push                esi
            //   ff5238               | call                dword ptr [edx + 0x38]

        $sequence_4 = { 8bf8 ffd6 3bfb 7472 }
            // n = 4, score = 700
            //   8bf8                 | mov                 edi, eax
            //   ffd6                 | call                esi
            //   3bfb                 | cmp                 edi, ebx
            //   7472                 | je                  0x74

        $sequence_5 = { 8b8df8feffff 8b85f4feffff 898d24feffff 8b8df0feffff 898d1cfeffff }
            // n = 5, score = 700
            //   8b8df8feffff         | mov                 ecx, dword ptr [ebp - 0x108]
            //   8b85f4feffff         | mov                 eax, dword ptr [ebp - 0x10c]
            //   898d24feffff         | mov                 dword ptr [ebp - 0x1dc], ecx
            //   8b8df0feffff         | mov                 ecx, dword ptr [ebp - 0x110]
            //   898d1cfeffff         | mov                 dword ptr [ebp - 0x1e4], ecx

        $sequence_6 = { 8b550c 8b06 51 52 56 }
            // n = 5, score = 700
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   51                   | push                ecx
            //   52                   | push                edx
            //   56                   | push                esi

        $sequence_7 = { 2bd7 6a00 42 83ec08 895590 db4590 }
            // n = 6, score = 700
            //   2bd7                 | sub                 edx, edi
            //   6a00                 | push                0
            //   42                   | inc                 edx
            //   83ec08               | sub                 esp, 8
            //   895590               | mov                 dword ptr [ebp - 0x70], edx
            //   db4590               | fild                dword ptr [ebp - 0x70]

        $sequence_8 = { 8bd0 8b45d4 51 f7da }
            // n = 4, score = 700
            //   8bd0                 | mov                 edx, eax
            //   8b45d4               | mov                 eax, dword ptr [ebp - 0x2c]
            //   51                   | push                ecx
            //   f7da                 | neg                 edx

        $sequence_9 = { 50 ffd3 8bd0 8d8d24ffffff ffd6 }
            // n = 5, score = 700
            //   50                   | push                eax
            //   ffd3                 | call                ebx
            //   8bd0                 | mov                 edx, eax
            //   8d8d24ffffff         | lea                 ecx, [ebp - 0xdc]
            //   ffd6                 | call                esi

    condition:
        7 of them and filesize < 1540096
}