rule win_systembc_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.systembc."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.systembc"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { b000 ae 75fd 8a57fe }
            // n = 4, score = 1200
            //   b000                 | mov                 al, 0
            //   ae                   | scasb               al, byte ptr es:[edi]
            //   75fd                 | jne                 0xffffffff
            //   8a57fe               | mov                 dl, byte ptr [edi - 2]

        $sequence_1 = { 8b7d0c 8b4d10 f3a4 5e }
            // n = 4, score = 1100
            //   8b7d0c               | dec                 eax
            //   8b4d10               | mov                 eax, dword ptr [ebp - 0x68]
            //   f3a4                 | dec                 eax
            //   5e                   | add                 eax, 0x1c

        $sequence_2 = { 33c0 ab 837d0c00 7403 ff47fc }
            // n = 5, score = 1100
            //   33c0                 | mov                 dl, byte ptr [edi - 2]
            //   ab                   | cmp                 dl, 0x39
            //   837d0c00             | xor                 byte ptr [edi], al
            //   7403                 | dec                 ecx
            //   ff47fc               | cmp                 dword ptr [ebp + 0xc], -2

        $sequence_3 = { e8???????? 8d5804 6a18 e8???????? 83c061 aa }
            // n = 6, score = 1100
            //   e8????????           |                     
            //   8d5804               | dec                 esp
            //   6a18                 | mov                 eax, eax
            //   e8????????           |                     
            //   83c061               | dec                 ecx
            //   aa                   | mov                 ecx, 0

        $sequence_4 = { 57 56 ff7508 e8???????? 8bd0 }
            // n = 5, score = 1100
            //   57                   | dec                 eax
            //   56                   | mov                 ecx, dword ptr [ebp - 0x6b8]
            //   ff7508               | dec                 ecx
            //   e8????????           |                     
            //   8bd0                 | lea                 edx, [eax + edi]

        $sequence_5 = { 66837aff00 7502 eb2e 837d0cff 7518 837d1000 }
            // n = 6, score = 1100
            //   66837aff00           | dec                 eax
            //   7502                 | mov                 ecx, 0
            //   eb2e                 | dec                 eax
            //   837d0cff             | mov                 edx, 0x10000
            //   7518                 | jb                  0x25
            //   837d1000             | dec                 eax

        $sequence_6 = { c7049e00000000 b800000000 5e 5f 5b }
            // n = 5, score = 1100
            //   c7049e00000000       | dec                 eax
            //   b800000000           | sub                 esp, 0x20
            //   5e                   | jne                 0x194
            //   5f                   | dec                 eax
            //   5b                   | sub                 esp, 0x20

        $sequence_7 = { 8b4514 ab 8b4518 ab b801000000 }
            // n = 5, score = 1100
            //   8b4514               | mov                 word ptr [edi + 0x4e], 1
            //   ab                   | mov                 byte ptr [edi + 0x51], 1
            //   8b4518               | mov                 byte ptr [edi + 0x7b], 0
            //   ab                   | dec                 eax
            //   b801000000           | sub                 esp, 0x40

        $sequence_8 = { 6a01 6a00 8b85bcfbffff 8b08 8b5118 50 }
            // n = 6, score = 1100
            //   6a01                 | dec                 esp
            //   6a00                 | lea                 eax, [edi + 0x4e]
            //   8b85bcfbffff         | dec                 ecx
            //   8b08                 | mov                 ecx, 0x32
            //   8b5118               | dec                 eax
            //   50                   | add                 esp, 0x20

        $sequence_9 = { c68573ffffff05 c68574ffffff01 c68575ffffff00 c68576ffffff01 48c78510ffffff01000000 }
            // n = 5, score = 200
            //   c68573ffffff05       | dec                 eax
            //   c68574ffffff01       | lea                 ecx, [esi + 0x188]
            //   c68575ffffff00       | dec                 eax
            //   c68576ffffff01       | lea                 edx, [ebp - 0x50]
            //   48c78510ffffff01000000     | mov    byte ptr [ebp - 0x8d], 5

        $sequence_10 = { 4883c420 66c7474e0100 c6475101 c6477b00 4883ec40 }
            // n = 5, score = 200
            //   4883c420             | dec                 eax
            //   66c7474e0100         | mov                 dword ptr [ebp - 0xf0], 1
            //   c6475101             | dec                 ecx
            //   c6477b00             | mov                 eax, 0xfffa
            //   4883ec40             | dec                 ecx

        $sequence_11 = { 0f858e010000 4883ec20 48c7c100000000 48c7c200000100 }
            // n = 4, score = 200
            //   0f858e010000         | dec                 eax
            //   4883ec20             | mov                 ecx, dword ptr [ebp - 0x6b8]
            //   48c7c100000000       | dec                 ecx
            //   48c7c200000100       | lea                 edx, [eax + edi]

        $sequence_12 = { 49c7c0faff0000 49c7c100000000 ff15???????? 4883c420 }
            // n = 4, score = 200
            //   49c7c0faff0000       | mov                 byte ptr [ebp - 0x8c], 1
            //   49c7c100000000       | mov                 byte ptr [ebp - 0x8b], 0
            //   ff15????????         |                     
            //   4883c420             | mov                 byte ptr [ebp - 0x8a], 1

        $sequence_13 = { e8???????? 4883c420 4883ec20 488d8e88010000 488d55b0 }
            // n = 5, score = 200
            //   e8????????           |                     
            //   4883c420             | dec                 eax
            //   4883ec20             | add                 esp, 0x20
            //   488d8e88010000       | dec                 eax
            //   488d55b0             | sub                 esp, 0x20

        $sequence_14 = { 4c8d474e 49c7c132000000 e8???????? 4883c420 488b4598 4883c01c 4883ec20 }
            // n = 7, score = 200
            //   4c8d474e             | add                 esp, 0x20
            //   49c7c132000000       | mov                 word ptr [edi + 0x4e], 1
            //   e8????????           |                     
            //   4883c420             | mov                 byte ptr [edi + 0x51], 1
            //   488b4598             | mov                 byte ptr [edi + 0x7b], 0
            //   4883c01c             | dec                 eax
            //   4883ec20             | sub                 esp, 0x40

        $sequence_15 = { 488b8d48f9ffff 498d1438 4c8bc0 49c7c100000000 }
            // n = 4, score = 200
            //   488b8d48f9ffff       | mov                 ecx, 0
            //   498d1438             | dec                 eax
            //   4c8bc0               | add                 esp, 0x20
            //   49c7c100000000       | dec                 eax

    condition:
        7 of them and filesize < 75776
}