rule win_t34loader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.t34loader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.t34loader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7424 88542438 eb1e 4885c0 7505 4585ff 7414 }
            // n = 7, score = 100
            //   7424                 | dec                 esp
            //   88542438             | mov                 eax, ebp
            //   eb1e                 | dec                 eax
            //   4885c0               | mov                 ebx, dword ptr [esp + 0x40]
            //   7505                 | dec                 eax
            //   4585ff               | mov                 edx, dword ptr [edi + 0x10]
            //   7414                 | dec                 eax

        $sequence_1 = { e8???????? 488d542420 488bcb e8???????? 488bcb e8???????? 84c0 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488d542420           | dec                 eax
            //   488bcb               | cmp                 eax, dword ptr [esp + 0x70]
            //   e8????????           |                     
            //   488bcb               | dec                 eax
            //   e8????????           |                     
            //   84c0                 | lea                 edx, [ebp - 8]

        $sequence_2 = { 743f 803d????????00 7436 48ffc0 4d8d1443 488b4587 48ffc0 }
            // n = 7, score = 100
            //   743f                 | mov                 dword ptr [ebp + 0x50], ebx
            //   803d????????00       |                     
            //   7436                 | dec                 ecx
            //   48ffc0               | cmp                 ebx, esi
            //   4d8d1443             | jne                 0x1fe2
            //   488b4587             | jmp                 0x2040
            //   48ffc0               | dec                 esp

        $sequence_3 = { e8???????? 488b5710 488bc8 4889542420 4c8bcb }
            // n = 5, score = 100
            //   e8????????           |                     
            //   488b5710             | dec                 eax
            //   488bc8               | lea                 ecx, [ebp - 0x48]
            //   4889542420           | dec                 eax
            //   4c8bcb               | lea                 edx, [ebp - 0x48]

        $sequence_4 = { 418ac0 884708 488b542440 488bcf e8???????? 84c0 0f84e6feffff }
            // n = 7, score = 100
            //   418ac0               | cmove               ebp, ecx
            //   884708               | cmp                 byte ptr [esp + 0x30], 0
            //   488b542440           | je                  0xcd9
            //   488bcf               | inc                 ecx
            //   e8????????           |                     
            //   84c0                 | mov                 cl, 0x2d
            //   0f84e6feffff         | dec                 ebp

        $sequence_5 = { 4c8bc7 488d4c2430 488bd6 e8???????? 488d4c2430 e8???????? }
            // n = 6, score = 100
            //   4c8bc7               | mov                 ecx, edi
            //   488d4c2430           | dec                 esp
            //   488bd6               | arpl                ax, bp
            //   e8????????           |                     
            //   488d4c2430           | test                eax, eax
            //   e8????????           |                     

        $sequence_6 = { 0f845e010000 488b0f 33db 4885c9 7441 488b4138 483918 }
            // n = 7, score = 100
            //   0f845e010000         | inc                 ecx
            //   488b0f               | movups              xmm0, xmmword ptr [eax]
            //   33db                 | dec                 ecx
            //   4885c9               | mov                 ebx, ecx
            //   7441                 | dec                 esp
            //   488b4138             | lea                 eax, [0x6ff6f]
            //   483918               | dec                 esp

        $sequence_7 = { e8???????? 488bd0 488d4d20 e8???????? 488bd3 488d4d30 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488bd0               | inc                 ebp
            //   488d4d20             | xor                 edx, edx
            //   e8????????           |                     
            //   488bd3               | test                al, al
            //   488d4d30             | dec                 eax
            //   e8????????           |                     

        $sequence_8 = { 488d4138 41b806000000 488d15b1370200 483950f0 740c 488b10 4885d2 }
            // n = 7, score = 100
            //   488d4138             | inc                 eax
            //   41b806000000         | push                ebx
            //   488d15b1370200       | dec                 eax
            //   483950f0             | sub                 esp, 0x20
            //   740c                 | dec                 eax
            //   488b10               | lea                 ebx, [ecx + 0xa8]
            //   4885d2               | dec                 eax

        $sequence_9 = { 5f 5e 5d c3 4c8d05d3b50200 498b14e8 8a44fa38 }
            // n = 7, score = 100
            //   5f                   | dec                 eax
            //   5e                   | mov                 dword ptr [edi], eax
            //   5d                   | cmp                 esi, 0x13
            //   c3                   | dec                 eax
            //   4c8d05d3b50200       | mov                 ecx, dword ptr [edi]
            //   498b14e8             | inc                 ebp
            //   8a44fa38             | xor                 eax, eax

    condition:
        7 of them and filesize < 1212416
}