rule win_tabmsgsql_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.tabmsgsql."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tabmsgsql"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? 83c404 ff15???????? 5e 33c0 5b 81c404d00700 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c404               | add                 esp, 4
            //   ff15????????         |                     
            //   5e                   | pop                 esi
            //   33c0                 | xor                 eax, eax
            //   5b                   | pop                 ebx
            //   81c404d00700         | add                 esp, 0x7d004

        $sequence_1 = { e9???????? 8b0d???????? 3bcb 0f8463feffff a1???????? 3bc3 0f8456feffff }
            // n = 7, score = 100
            //   e9????????           |                     
            //   8b0d????????         |                     
            //   3bcb                 | cmp                 ecx, ebx
            //   0f8463feffff         | je                  0xfffffe69
            //   a1????????           |                     
            //   3bc3                 | cmp                 eax, ebx
            //   0f8456feffff         | je                  0xfffffe5c

        $sequence_2 = { 6a01 8bcb ff15???????? eb45 8b430c 83f81f 7704 }
            // n = 7, score = 100
            //   6a01                 | push                1
            //   8bcb                 | mov                 ecx, ebx
            //   ff15????????         |                     
            //   eb45                 | jmp                 0x47
            //   8b430c               | mov                 eax, dword ptr [ebx + 0xc]
            //   83f81f               | cmp                 eax, 0x1f
            //   7704                 | ja                  6

        $sequence_3 = { 83c9ff 33c0 8d951217fcff f2ae f7d1 2bf9 50 }
            // n = 7, score = 100
            //   83c9ff               | or                  ecx, 0xffffffff
            //   33c0                 | xor                 eax, eax
            //   8d951217fcff         | lea                 edx, [ebp - 0x3e8ee]
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   2bf9                 | sub                 edi, ecx
            //   50                   | push                eax

        $sequence_4 = { 8b842430f50100 83c424 85c0 5f }
            // n = 4, score = 100
            //   8b842430f50100       | mov                 eax, dword ptr [esp + 0x1f530]
            //   83c424               | add                 esp, 0x24
            //   85c0                 | test                eax, eax
            //   5f                   | pop                 edi

        $sequence_5 = { 51 b9???????? 895dfc a2???????? e8???????? 3bc3 0f84d7000000 }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   b9????????           |                     
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   a2????????           |                     
            //   e8????????           |                     
            //   3bc3                 | cmp                 eax, ebx
            //   0f84d7000000         | je                  0xdd

        $sequence_6 = { f3a5 8bc8 33c0 83e103 f3a4 8bbc2438060000 83c9ff }
            // n = 7, score = 100
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8bc8                 | mov                 ecx, eax
            //   33c0                 | xor                 eax, eax
            //   83e103               | and                 ecx, 3
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   8bbc2438060000       | mov                 edi, dword ptr [esp + 0x638]
            //   83c9ff               | or                  ecx, 0xffffffff

        $sequence_7 = { 5b 83e103 b801000000 f3a4 }
            // n = 4, score = 100
            //   5b                   | pop                 ebx
            //   83e103               | and                 ecx, 3
            //   b801000000           | mov                 eax, 1
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]

        $sequence_8 = { 3de8030000 a3???????? 7d0c c705????????e8030000 }
            // n = 4, score = 100
            //   3de8030000           | cmp                 eax, 0x3e8
            //   a3????????           |                     
            //   7d0c                 | jge                 0xe
            //   c705????????e8030000     |     

        $sequence_9 = { 33c0 68???????? f2ae f7d1 2bf9 8d442434 8bd1 }
            // n = 7, score = 100
            //   33c0                 | xor                 eax, eax
            //   68????????           |                     
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]
            //   f7d1                 | not                 ecx
            //   2bf9                 | sub                 edi, ecx
            //   8d442434             | lea                 eax, [esp + 0x34]
            //   8bd1                 | mov                 edx, ecx

    condition:
        7 of them and filesize < 163840
}