rule win_tclient_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.tclient."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tclient"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffb5f0fdffff ff95e4fdffff 8bf0 83c40c 85f6 0f85ec020000 8b85f0fdffff }
            // n = 7, score = 100
            //   ffb5f0fdffff         | push                dword ptr [ebp - 0x210]
            //   ff95e4fdffff         | call                dword ptr [ebp - 0x21c]
            //   8bf0                 | mov                 esi, eax
            //   83c40c               | add                 esp, 0xc
            //   85f6                 | test                esi, esi
            //   0f85ec020000         | jne                 0x2f2
            //   8b85f0fdffff         | mov                 eax, dword ptr [ebp - 0x210]

        $sequence_1 = { 6a00 50 e8???????? 83c40c c70340000000 8bcb e8???????? }
            // n = 7, score = 100
            //   6a00                 | push                0
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   c70340000000         | mov                 dword ptr [ebx], 0x40
            //   8bcb                 | mov                 ecx, ebx
            //   e8????????           |                     

        $sequence_2 = { 8d4508 8bcc 50 e8???????? 8d4dcc 885dfc e8???????? }
            // n = 7, score = 100
            //   8d4508               | lea                 eax, [ebp + 8]
            //   8bcc                 | mov                 ecx, esp
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d4dcc               | lea                 ecx, [ebp - 0x34]
            //   885dfc               | mov                 byte ptr [ebp - 4], bl
            //   e8????????           |                     

        $sequence_3 = { 0f8521feffff 837d1001 0f857a010000 85f6 745f 8b4e04 57 }
            // n = 7, score = 100
            //   0f8521feffff         | jne                 0xfffffe27
            //   837d1001             | cmp                 dword ptr [ebp + 0x10], 1
            //   0f857a010000         | jne                 0x180
            //   85f6                 | test                esi, esi
            //   745f                 | je                  0x61
            //   8b4e04               | mov                 ecx, dword ptr [esi + 4]
            //   57                   | push                edi

        $sequence_4 = { ff7508 8bd7 8bce e8???????? 59 59 5f }
            // n = 7, score = 100
            //   ff7508               | push                dword ptr [ebp + 8]
            //   8bd7                 | mov                 edx, edi
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   5f                   | pop                 edi

        $sequence_5 = { 8bf1 57 84d2 756a b800020000 66858620030000 755c }
            // n = 7, score = 100
            //   8bf1                 | mov                 esi, ecx
            //   57                   | push                edi
            //   84d2                 | test                dl, dl
            //   756a                 | jne                 0x6c
            //   b800020000           | mov                 eax, 0x200
            //   66858620030000       | test                word ptr [esi + 0x320], ax
            //   755c                 | jne                 0x5e

        $sequence_6 = { 8d45c8 50 8d7730 56 8d5750 8d4de8 e8???????? }
            // n = 7, score = 100
            //   8d45c8               | lea                 eax, [ebp - 0x38]
            //   50                   | push                eax
            //   8d7730               | lea                 esi, [edi + 0x30]
            //   56                   | push                esi
            //   8d5750               | lea                 edx, [edi + 0x50]
            //   8d4de8               | lea                 ecx, [ebp - 0x18]
            //   e8????????           |                     

        $sequence_7 = { 8b049dc0a04700 0fb6440828 83e001 0f848d000000 b8ffffff7f 3b4510 1bc0 }
            // n = 7, score = 100
            //   8b049dc0a04700       | mov                 eax, dword ptr [ebx*4 + 0x47a0c0]
            //   0fb6440828           | movzx               eax, byte ptr [eax + ecx + 0x28]
            //   83e001               | and                 eax, 1
            //   0f848d000000         | je                  0x93
            //   b8ffffff7f           | mov                 eax, 0x7fffffff
            //   3b4510               | cmp                 eax, dword ptr [ebp + 0x10]
            //   1bc0                 | sbb                 eax, eax

        $sequence_8 = { 3bd8 7e2c 8d95b0feffff 8d8d60faffff e8???????? 8b9da8faffff 8bf8 }
            // n = 7, score = 100
            //   3bd8                 | cmp                 ebx, eax
            //   7e2c                 | jle                 0x2e
            //   8d95b0feffff         | lea                 edx, [ebp - 0x150]
            //   8d8d60faffff         | lea                 ecx, [ebp - 0x5a0]
            //   e8????????           |                     
            //   8b9da8faffff         | mov                 ebx, dword ptr [ebp - 0x558]
            //   8bf8                 | mov                 edi, eax

        $sequence_9 = { 33c0 66898625030000 89862a030000 888627030000 888622030000 884660 88467c }
            // n = 7, score = 100
            //   33c0                 | xor                 eax, eax
            //   66898625030000       | mov                 word ptr [esi + 0x325], ax
            //   89862a030000         | mov                 dword ptr [esi + 0x32a], eax
            //   888627030000         | mov                 byte ptr [esi + 0x327], al
            //   888622030000         | mov                 byte ptr [esi + 0x322], al
            //   884660               | mov                 byte ptr [esi + 0x60], al
            //   88467c               | mov                 byte ptr [esi + 0x7c], al

    condition:
        7 of them and filesize < 1063936
}