rule win_telb_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.telb."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.telb"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { e8???????? a1???????? 33c4 89842404100000 56 57 6a00 }
            // n = 7, score = 200
            //   e8????????           |                     
            //   a1????????           |                     
            //   33c4                 | xor                 eax, esp
            //   89842404100000       | mov                 dword ptr [esp + 0x1004], eax
            //   56                   | push                esi
            //   57                   | push                edi
            //   6a00                 | push                0

        $sequence_1 = { 51 e8???????? 83c408 8d85e8dfffff c78598dfffff00000000 8985a0dfffff }
            // n = 6, score = 200
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c408               | add                 esp, 8
            //   8d85e8dfffff         | lea                 eax, [ebp - 0x2018]
            //   c78598dfffff00000000     | mov    dword ptr [ebp - 0x2068], 0
            //   8985a0dfffff         | mov                 dword ptr [ebp - 0x2060], eax

        $sequence_2 = { eb07 6a16 68???????? e8???????? 8d4c2430 e8???????? }
            // n = 6, score = 200
            //   eb07                 | jmp                 9
            //   6a16                 | push                0x16
            //   68????????           |                     
            //   e8????????           |                     
            //   8d4c2430             | lea                 ecx, [esp + 0x30]
            //   e8????????           |                     

        $sequence_3 = { 81cf00000003 89bd48eeffff 0f1000 0f1185b0eeffff f30f7e4010 }
            // n = 5, score = 200
            //   81cf00000003         | or                  edi, 0x3000000
            //   89bd48eeffff         | mov                 dword ptr [ebp - 0x11b8], edi
            //   0f1000               | movups              xmm0, xmmword ptr [eax]
            //   0f1185b0eeffff       | movups              xmmword ptr [ebp - 0x1150], xmm0
            //   f30f7e4010           | movq                xmm0, qword ptr [eax + 0x10]

        $sequence_4 = { ffd1 8bf0 8b442414 50 8b08 ff5108 }
            // n = 6, score = 200
            //   ffd1                 | call                ecx
            //   8bf0                 | mov                 esi, eax
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]
            //   50                   | push                eax
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   ff5108               | call                dword ptr [ecx + 8]

        $sequence_5 = { 8d8d88efffff e8???????? 33c9 81cf80000000 89bd38eeffff }
            // n = 5, score = 200
            //   8d8d88efffff         | lea                 ecx, [ebp - 0x1078]
            //   e8????????           |                     
            //   33c9                 | xor                 ecx, ecx
            //   81cf80000000         | or                  edi, 0x80
            //   89bd38eeffff         | mov                 dword ptr [ebp - 0x11c8], edi

        $sequence_6 = { c7400400000000 8985e8edffff 8908 c645fc09 8b85a8eeffff 89853ceeffff 8b85dceeffff }
            // n = 7, score = 200
            //   c7400400000000       | mov                 dword ptr [eax + 4], 0
            //   8985e8edffff         | mov                 dword ptr [ebp - 0x1218], eax
            //   8908                 | mov                 dword ptr [eax], ecx
            //   c645fc09             | mov                 byte ptr [ebp - 4], 9
            //   8b85a8eeffff         | mov                 eax, dword ptr [ebp - 0x1158]
            //   89853ceeffff         | mov                 dword ptr [ebp - 0x11c4], eax
            //   8b85dceeffff         | mov                 eax, dword ptr [ebp - 0x1124]

        $sequence_7 = { c644241b01 8b14b8 8bca 8d7102 668b01 }
            // n = 5, score = 200
            //   c644241b01           | mov                 byte ptr [esp + 0x1b], 1
            //   8b14b8               | mov                 edx, dword ptr [eax + edi*4]
            //   8bca                 | mov                 ecx, edx
            //   8d7102               | lea                 esi, [ecx + 2]
            //   668b01               | mov                 ax, word ptr [ecx]

        $sequence_8 = { eb06 8bbd48eeffff 80bd4feeffff00 0f84a1010000 51 8d8d88efffff e8???????? }
            // n = 7, score = 200
            //   eb06                 | jmp                 8
            //   8bbd48eeffff         | mov                 edi, dword ptr [ebp - 0x11b8]
            //   80bd4feeffff00       | cmp                 byte ptr [ebp - 0x11b1], 0
            //   0f84a1010000         | je                  0x1a7
            //   51                   | push                ecx
            //   8d8d88efffff         | lea                 ecx, [ebp - 0x1078]
            //   e8????????           |                     

        $sequence_9 = { c7401407000000 668908 8d8db8efffff c645fc28 }
            // n = 4, score = 200
            //   c7401407000000       | mov                 dword ptr [eax + 0x14], 7
            //   668908               | mov                 word ptr [eax], cx
            //   8d8db8efffff         | lea                 ecx, [ebp - 0x1048]
            //   c645fc28             | mov                 byte ptr [ebp - 4], 0x28

    condition:
        7 of them and filesize < 286720
}