rule win_telebot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.telebot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.telebot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 a3???????? 0f8408050000 c7442404???????? 893424 ffd3 83ec08 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   a3????????           |                     
            //   0f8408050000         | je                  0x50e
            //   c7442404????????     |                     
            //   893424               | mov                 dword ptr [esp], esi
            //   ffd3                 | call                ebx
            //   83ec08               | sub                 esp, 8

        $sequence_1 = { 0fb645ff 83ef01 d3e0 83c108 01c6 83f91f 76e2 }
            // n = 7, score = 100
            //   0fb645ff             | movzx               eax, byte ptr [ebp - 1]
            //   83ef01               | sub                 edi, 1
            //   d3e0                 | shl                 eax, cl
            //   83c108               | add                 ecx, 8
            //   01c6                 | add                 esi, eax
            //   83f91f               | cmp                 ecx, 0x1f
            //   76e2                 | jbe                 0xffffffe4

        $sequence_2 = { 8b4b24 85c9 7472 c7442408cc1b0000 c744240401000000 891424 ffd0 }
            // n = 7, score = 100
            //   8b4b24               | mov                 ecx, dword ptr [ebx + 0x24]
            //   85c9                 | test                ecx, ecx
            //   7472                 | je                  0x74
            //   c7442408cc1b0000     | mov                 dword ptr [esp + 8], 0x1bcc
            //   c744240401000000     | mov                 dword ptr [esp + 4], 1
            //   891424               | mov                 dword ptr [esp], edx
            //   ffd0                 | call                eax

        $sequence_3 = { 897c2408 896c2404 890424 e8???????? 891c24 e8???????? }
            // n = 6, score = 100
            //   897c2408             | mov                 dword ptr [esp + 8], edi
            //   896c2404             | mov                 dword ptr [esp + 4], ebp
            //   890424               | mov                 dword ptr [esp], eax
            //   e8????????           |                     
            //   891c24               | mov                 dword ptr [esp], ebx
            //   e8????????           |                     

        $sequence_4 = { 7e0c 83c501 01c0 8d3c2a 39f7 72ea }
            // n = 6, score = 100
            //   7e0c                 | jle                 0xe
            //   83c501               | add                 ebp, 1
            //   01c0                 | add                 eax, eax
            //   8d3c2a               | lea                 edi, [edx + ebp]
            //   39f7                 | cmp                 edi, esi
            //   72ea                 | jb                  0xffffffec

        $sequence_5 = { 8d8230050000 f3a5 8b4d4c 8db530050000 39f1 7351 29f0 }
            // n = 7, score = 100
            //   8d8230050000         | lea                 eax, [edx + 0x530]
            //   f3a5                 | rep movsd           dword ptr es:[edi], dword ptr [esi]
            //   8b4d4c               | mov                 ecx, dword ptr [ebp + 0x4c]
            //   8db530050000         | lea                 esi, [ebp + 0x530]
            //   39f1                 | cmp                 ecx, esi
            //   7351                 | jae                 0x53
            //   29f0                 | sub                 eax, esi

        $sequence_6 = { 38cb 0f84d5000000 84db 74d1 83c201 31c0 b901000000 }
            // n = 7, score = 100
            //   38cb                 | cmp                 bl, cl
            //   0f84d5000000         | je                  0xdb
            //   84db                 | test                bl, bl
            //   74d1                 | je                  0xffffffd3
            //   83c201               | add                 edx, 1
            //   31c0                 | xor                 eax, eax
            //   b901000000           | mov                 ecx, 1

        $sequence_7 = { 5f 5d c3 e8???????? 8b470c }
            // n = 5, score = 100
            //   5f                   | pop                 edi
            //   5d                   | pop                 ebp
            //   c3                   | ret                 
            //   e8????????           |                     
            //   8b470c               | mov                 eax, dword ptr [edi + 0xc]

        $sequence_8 = { 895008 89f2 c1ea08 89500c 8b442424 8b5010 f6c602 }
            // n = 7, score = 100
            //   895008               | mov                 dword ptr [eax + 8], edx
            //   89f2                 | mov                 edx, esi
            //   c1ea08               | shr                 edx, 8
            //   89500c               | mov                 dword ptr [eax + 0xc], edx
            //   8b442424             | mov                 eax, dword ptr [esp + 0x24]
            //   8b5010               | mov                 edx, dword ptr [eax + 0x10]
            //   f6c602               | test                dh, 2

        $sequence_9 = { 895c2420 c744241ccec14000 89742418 c7442414cec14000 c7442410d0c14000 89442408 8d84244f200000 }
            // n = 7, score = 100
            //   895c2420             | mov                 dword ptr [esp + 0x20], ebx
            //   c744241ccec14000     | mov                 dword ptr [esp + 0x1c], 0x40c1ce
            //   89742418             | mov                 dword ptr [esp + 0x18], esi
            //   c7442414cec14000     | mov                 dword ptr [esp + 0x14], 0x40c1ce
            //   c7442410d0c14000     | mov                 dword ptr [esp + 0x10], 0x40c1d0
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   8d84244f200000       | lea                 eax, [esp + 0x204f]

    condition:
        7 of them and filesize < 393216
}