rule win_telepowerbot_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.telepowerbot."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.telepowerbot"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a01 68???????? 6a01 50 68???????? ff75f8 ffd6 }
            // n = 7, score = 200
            //   6a01                 | push                1
            //   68????????           |                     
            //   6a01                 | push                1
            //   50                   | push                eax
            //   68????????           |                     
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   ffd6                 | call                esi

        $sequence_1 = { 817848d0924100 7409 ff7048 e8???????? 59 }
            // n = 5, score = 200
            //   817848d0924100       | cmp                 dword ptr [eax + 0x48], 0x4192d0
            //   7409                 | je                  0xb
            //   ff7048               | push                dword ptr [eax + 0x48]
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_2 = { ff348518234100 52 51 e8???????? 83c40c }
            // n = 5, score = 200
            //   ff348518234100       | push                dword ptr [eax*4 + 0x412318]
            //   52                   | push                edx
            //   51                   | push                ecx
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc

        $sequence_3 = { 43 03c3 03c7 ff348518234100 52 51 e8???????? }
            // n = 7, score = 200
            //   43                   | inc                 ebx
            //   03c3                 | add                 eax, ebx
            //   03c7                 | add                 eax, edi
            //   ff348518234100       | push                dword ptr [eax*4 + 0x412318]
            //   52                   | push                edx
            //   51                   | push                ecx
            //   e8????????           |                     

        $sequence_4 = { eb55 0fb607 0fbe8800914100 41 894dd4 3bca 0f8f9e010000 }
            // n = 7, score = 200
            //   eb55                 | jmp                 0x57
            //   0fb607               | movzx               eax, byte ptr [edi]
            //   0fbe8800914100       | movsx               ecx, byte ptr [eax + 0x419100]
            //   41                   | inc                 ecx
            //   894dd4               | mov                 dword ptr [ebp - 0x2c], ecx
            //   3bca                 | cmp                 ecx, edx
            //   0f8f9e010000         | jg                  0x1a4

        $sequence_5 = { f20f59db 660f282d???????? 660f59f5 660f28aaf05e4100 660f54e5 660f58fe 660f58fc }
            // n = 7, score = 200
            //   f20f59db             | mulsd               xmm3, xmm3
            //   660f282d????????     |                     
            //   660f59f5             | mulpd               xmm6, xmm5
            //   660f28aaf05e4100     | movapd              xmm5, xmmword ptr [edx + 0x415ef0]
            //   660f54e5             | andpd               xmm4, xmm5
            //   660f58fe             | addpd               xmm7, xmm6
            //   660f58fc             | addpd               xmm7, xmm4

        $sequence_6 = { eb07 8b04f5cc4e4100 5f 5e 5b }
            // n = 5, score = 200
            //   eb07                 | jmp                 9
            //   8b04f5cc4e4100       | mov                 eax, dword ptr [esi*8 + 0x414ecc]
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx

        $sequence_7 = { 8b8d84f8ffff 85c9 0f84b5050000 8b048d5c3d4100 8985a8f8ffff }
            // n = 5, score = 200
            //   8b8d84f8ffff         | mov                 ecx, dword ptr [ebp - 0x77c]
            //   85c9                 | test                ecx, ecx
            //   0f84b5050000         | je                  0x5bb
            //   8b048d5c3d4100       | mov                 eax, dword ptr [ecx*4 + 0x413d5c]
            //   8985a8f8ffff         | mov                 dword ptr [ebp - 0x758], eax

        $sequence_8 = { c1ff06 6bd838 8b04bdf09d4100 f644032801 7444 837c0318ff }
            // n = 6, score = 200
            //   c1ff06               | sar                 edi, 6
            //   6bd838               | imul                ebx, eax, 0x38
            //   8b04bdf09d4100       | mov                 eax, dword ptr [edi*4 + 0x419df0]
            //   f644032801           | test                byte ptr [ebx + eax + 0x28], 1
            //   7444                 | je                  0x46
            //   837c0318ff           | cmp                 dword ptr [ebx + eax + 0x18], -1

        $sequence_9 = { 85c9 0f84b5050000 8b048d5c3d4100 8985a8f8ffff 85c0 7562 }
            // n = 6, score = 200
            //   85c9                 | test                ecx, ecx
            //   0f84b5050000         | je                  0x5bb
            //   8b048d5c3d4100       | mov                 eax, dword ptr [ecx*4 + 0x413d5c]
            //   8985a8f8ffff         | mov                 dword ptr [ebp - 0x758], eax
            //   85c0                 | test                eax, eax
            //   7562                 | jne                 0x64

    condition:
        7 of them and filesize < 237568
}