rule win_tellyouthepass_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.tellyouthepass."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tellyouthepass"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488b0d???????? eb0a 488b4c2448 488b5c2420 48894c2440 48895c2428 488d050b4e1000 }
            // n = 7, score = 100
            //   488b0d????????       |                     
            //   eb0a                 | add                 esp, 0x140
            //   488b4c2448           | ret                 
            //   488b5c2420           | mov                 eax, 1
            //   48894c2440           | dec                 eax
            //   48895c2428           | mov                 ebp, dword ptr [esp + 0x138]
            //   488d050b4e1000       | dec                 eax

        $sequence_1 = { 4d85c0 7f1d 488b8c24f0000000 488b9424f8000000 488b9c24a8010000 e9???????? 4889bc2418010000 }
            // n = 7, score = 100
            //   4d85c0               | lea                 ecx, [0x10d838]
            //   7f1d                 | mov                 edi, 0xe
            //   488b8c24f0000000     | nop                 dword ptr [eax]
            //   488b9424f8000000     | test                byte ptr [eax], al
            //   488b9c24a8010000     | dec                 eax
            //   e9????????           |                     
            //   4889bc2418010000     | lea                 eax, [0xd3f34]

        $sequence_2 = { f20f10442440 e8???????? 488d051a1f1a00 bb0c000000 6690 e8???????? e8???????? }
            // n = 7, score = 100
            //   f20f10442440         | lea                 esp, [esp - 8]
            //   e8????????           |                     
            //   488d051a1f1a00       | dec                 ebp
            //   bb0c000000           | cmp                 esp, dword ptr [esi + 0x10]
            //   6690                 | jbe                 0xe5b
            //   e8????????           |                     
            //   e8????????           |                     

        $sequence_3 = { 80f902 7345 884c2417 0fb6d1 4889542420 48c1e206 488d35728f3000 }
            // n = 7, score = 100
            //   80f902               | lea                 ecx, [esp + 0x60]
            //   7345                 | inc                 esp
            //   884c2417             | movups              xmmword ptr [ecx], xmm7
            //   0fb6d1               | dec                 eax
            //   4889542420           | lea                 edx, [esp + 0x70]
            //   48c1e206             | inc                 esp
            //   488d35728f3000       | movups              xmmword ptr [edx], xmm7

        $sequence_4 = { 48c740102c000000 833d????????00 750d 488d0d57b70600 48894808 eb10 488d7808 }
            // n = 7, score = 100
            //   48c740102c000000     | mov                 ebp, dword ptr [esp + 0x28]
            //   833d????????00       |                     
            //   750d                 | dec                 eax
            //   488d0d57b70600       | add                 esp, 0x30
            //   48894808             | dec                 eax
            //   eb10                 | mov                 ebp, dword ptr [esp + 0x28]
            //   488d7808             | dec                 eax

        $sequence_5 = { 4c8b4028 4c8b4830 4c8b5020 488dbc2490010000 488d3585530b00 48896c24f0 488d6c24f0 }
            // n = 7, score = 100
            //   4c8b4028             | add                 esp, 0xc8
            //   4c8b4830             | ret                 
            //   4c8b5020             | dec                 eax
            //   488dbc2490010000     | lea                 eax, [0x997b7]
            //   488d3585530b00       | dec                 eax
            //   48896c24f0           | mov                 ebx, dword ptr [esp + 0x80]
            //   488d6c24f0           | dec                 eax

        $sequence_6 = { 6690 eb10 488d7a70 488d155b4b0d00 e8???????? 90 488b15???????? }
            // n = 7, score = 100
            //   6690                 | mov                 dword ptr [esp + 0x80], eax
            //   eb10                 | dec                 eax
            //   488d7a70             | mov                 edx, dword ptr [esp + 0xc8]
            //   488d155b4b0d00       | dec                 eax
            //   e8????????           |                     
            //   90                   | mov                 esi, dword ptr [edx + 8]
            //   488b15????????       |                     

        $sequence_7 = { bb06000000 90 e8???????? 488b442410 e8???????? 488d0525631700 bb0b000000 }
            // n = 7, score = 100
            //   bb06000000           | dec                 eax
            //   90                   | mov                 dword ptr [esp + 0x10], ebx
            //   e8????????           |                     
            //   488b442410           | dec                 eax
            //   e8????????           |                     
            //   488d0525631700       | mov                 dword ptr [eax + 0x10], 0
            //   bb0b000000           | dec                 eax

        $sequence_8 = { eb09 4889c7 90 e8???????? 488d0514690e00 488b5c2438 488d0d73e11000 }
            // n = 7, score = 100
            //   eb09                 | mov                 edi, dword ptr [esp + 0x50]
            //   4889c7               | dec                 ecx
            //   90                   | add                 ecx, 4
            //   e8????????           |                     
            //   488d0514690e00       | jmp                 0x5a9
            //   488b5c2438           | dec                 ebp
            //   488d0d73e11000       | mov                 ebp, esp

        $sequence_9 = { eb14 488d7818 488b8c24c0020000 0f1f00 e8???????? 48c740100b000000 488d0d9ed01300 }
            // n = 7, score = 100
            //   eb14                 | dec                 ebp
            //   488d7818             | mov                 ecx, dword ptr [ecx + 0x18]
            //   488b8c24c0020000     | dec                 esp
            //   0f1f00               | mov                 ebx, dword ptr [esp + 0x3a8]
            //   e8????????           |                     
            //   48c740100b000000     | dec                 eax
            //   488d0d9ed01300       | mov                 eax, dword ptr [esp + 0xf8]

    condition:
        7 of them and filesize < 7152640
}