rule win_temp_stealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.temp_stealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.temp_stealer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488b4d08 e8???????? 4403f7 4883c330 443bb518020000 0f8c37ffffff 488b5d00 }
            // n = 7, score = 100
            //   488b4d08             | mov                 dword ptr [esp + 0x20], edx
            //   e8????????           |                     
            //   4403f7               | dec                 eax
            //   4883c330             | lea                 ecx, [ebp - 0x20]
            //   443bb518020000       | nop                 
            //   0f8c37ffffff         | inc                 ebp
            //   488b5d00             | xor                 ebp, ebp

        $sequence_1 = { 488d1537b00300 488bcb ff15???????? 488945b0 488d1533b00300 488bcb ff15???????? }
            // n = 7, score = 100
            //   488d1537b00300       | inc                 eax
            //   488bcb               | test                bh, 1
            //   ff15????????         |                     
            //   488945b0             | je                  0x38e
            //   488d1533b00300       | mov                 edx, 0x38
            //   488bcb               | dec                 eax
            //   ff15????????         |                     

        $sequence_2 = { f20f58cb f20f58cf f20f102d???????? 488d1592e10100 f20f59ee f2430f1004c1 }
            // n = 6, score = 100
            //   f20f58cb             | je                  0x3a6
            //   f20f58cf             | mov                 byte ptr [eax], 0
            //   f20f102d????????     |                     
            //   488d1592e10100       | mov                 eax, dword ptr [ebx + 8]
            //   f20f59ee             | mov                 dword ptr [edi + 8], eax
            //   f2430f1004c1         | jmp                 0x3b7

        $sequence_3 = { 4533c0 baa00f0000 e8???????? 488b05???????? 4c8d05f52b0300 488bd5 48c1fa06 }
            // n = 7, score = 100
            //   4533c0               | mov                 eax, 4
            //   baa00f0000           | dec                 eax
            //   e8????????           |                     
            //   488b05????????       |                     
            //   4c8d05f52b0300       | lea                 edx, [0x36c4e]
            //   488bd5               | dec                 eax
            //   48c1fa06             | mov                 ecx, eax

        $sequence_4 = { 488d0526dc0100 483947f0 741a 488b0f 4885c9 7412 833900 }
            // n = 7, score = 100
            //   488d0526dc0100       | dec                 eax
            //   483947f0             | cmp                 dword ptr [edi + 0x18], 8
            //   741a                 | jb                  0xc75
            //   488b0f               | dec                 eax
            //   4885c9               | mov                 eax, dword ptr [edi]
            //   7412                 | dec                 eax
            //   833900               | mov                 ecx, ebx

        $sequence_5 = { 90 488b8d80000000 e8???????? 90 498bcd }
            // n = 5, score = 100
            //   90                   | test                ebx, ebx
            //   488b8d80000000       | je                  0x169
            //   e8????????           |                     
            //   90                   | dec                 eax
            //   498bcd               | cmp                 ebx, edi

        $sequence_6 = { 488b13 48c1e205 4883c208 488bcb e8???????? 90 4183660800 }
            // n = 7, score = 100
            //   488b13               | lea                 eax, [0x29025]
            //   48c1e205             | dec                 eax
            //   4883c208             | mov                 dword ptr [ebp - 9], eax
            //   488bcb               | dec                 eax
            //   e8????????           |                     
            //   90                   | mov                 dword ptr [ebp + 7], eax
            //   4183660800           | dec                 eax

        $sequence_7 = { 894708 488d5901 41bf20000000 418bc7 48f7e3 498d4fdf 480f40c1 }
            // n = 7, score = 100
            //   894708               | lea                 ecx, [ecx + ecx*8]
            //   488d5901             | dec                 eax
            //   41bf20000000         | lea                 edx, [eax + ecx*8]
            //   418bc7               | jmp                 0x3d4
            //   48f7e3               | dec                 eax
            //   498d4fdf             | lea                 edx, [0x25ba4]
            //   480f40c1             | test                byte ptr [edx + 0x38], 0x20

        $sequence_8 = { 48895c2478 488d5530 488d4c2460 e8???????? 90 488d5580 }
            // n = 6, score = 100
            //   48895c2478           | dec                 ecx
            //   488d5530             | mov                 edx, eax
            //   488d4c2460           | dec                 eax
            //   e8????????           |                     
            //   90                   | mov                 ecx, edi
            //   488d5580             | dec                 eax

        $sequence_9 = { 90 488d442440 48894558 4c897c2440 4c897c2450 48895c2458 488d153cc80300 }
            // n = 7, score = 100
            //   90                   | dec                 eax
            //   488d442440           | mov                 ecx, ebx
            //   48894558             | nop                 
            //   4c897c2440           | nop                 
            //   4c897c2450           | dec                 eax
            //   48895c2458           | mov                 ecx, dword ptr [ebp + 0x10]
            //   488d153cc80300       | dec                 eax

    condition:
        7 of them and filesize < 652288
}