rule win_terminator_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.terminator_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.terminator_rat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffb7e8feffff 8d854d010000 8987e8feffff 8b8541010000 c1e006 }
            // n = 5, score = 500
            //   ffb7e8feffff         | push                dword ptr [edi - 0x118]
            //   8d854d010000         | lea                 eax, [ebp + 0x14d]
            //   8987e8feffff         | mov                 dword ptr [edi - 0x118], eax
            //   8b8541010000         | mov                 eax, dword ptr [ebp + 0x141]
            //   c1e006               | shl                 eax, 6

        $sequence_1 = { c0c003 3441 c0c003 3452 c0c003 3443 }
            // n = 6, score = 500
            //   c0c003               | rol                 al, 3
            //   3441                 | xor                 al, 0x41
            //   c0c003               | rol                 al, 3
            //   3452                 | xor                 al, 0x52
            //   c0c003               | rol                 al, 3
            //   3443                 | xor                 al, 0x43

        $sequence_2 = { 6a04 bb00040000 57 53 6a00 }
            // n = 5, score = 500
            //   6a04                 | push                4
            //   bb00040000           | mov                 ebx, 0x400
            //   57                   | push                edi
            //   53                   | push                ebx
            //   6a00                 | push                0

        $sequence_3 = { 53 56 8b7708 ff77fc ffb51d010000 8f47f4 }
            // n = 6, score = 500
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8b7708               | mov                 esi, dword ptr [edi + 8]
            //   ff77fc               | push                dword ptr [edi - 4]
            //   ffb51d010000         | push                dword ptr [ebp + 0x11d]
            //   8f47f4               | pop                 dword ptr [edi - 0xc]

        $sequence_4 = { 8d4618 50 8b8539010000 03c1 50 e8???????? 8b4610 }
            // n = 7, score = 500
            //   8d4618               | lea                 eax, [esi + 0x18]
            //   50                   | push                eax
            //   8b8539010000         | mov                 eax, dword ptr [ebp + 0x139]
            //   03c1                 | add                 eax, ecx
            //   50                   | push                eax
            //   e8????????           |                     
            //   8b4610               | mov                 eax, dword ptr [esi + 0x10]

        $sequence_5 = { 50 e8???????? 83f8ff 7408 81c400040000 }
            // n = 5, score = 500
            //   50                   | push                eax
            //   e8????????           |                     
            //   83f8ff               | cmp                 eax, -1
            //   7408                 | je                  0xa
            //   81c400040000         | add                 esp, 0x400

        $sequence_6 = { 8b4b0c ac 3459 c0c803 3448 c0c803 }
            // n = 6, score = 500
            //   8b4b0c               | mov                 ecx, dword ptr [ebx + 0xc]
            //   ac                   | lodsb               al, byte ptr [esi]
            //   3459                 | xor                 al, 0x59
            //   c0c803               | ror                 al, 3
            //   3448                 | xor                 al, 0x48
            //   c0c803               | ror                 al, 3

        $sequence_7 = { 8f87f0fbffff 5e 5b 81c410040000 }
            // n = 4, score = 500
            //   8f87f0fbffff         | pop                 dword ptr [edi - 0x410]
            //   5e                   | pop                 esi
            //   5b                   | pop                 ebx
            //   81c410040000         | add                 esp, 0x410

        $sequence_8 = { e9???????? ff7610 8b8d35010000 8d4618 50 8b8539010000 03c1 }
            // n = 7, score = 500
            //   e9????????           |                     
            //   ff7610               | push                dword ptr [esi + 0x10]
            //   8b8d35010000         | mov                 ecx, dword ptr [ebp + 0x135]
            //   8d4618               | lea                 eax, [esi + 0x18]
            //   50                   | push                eax
            //   8b8539010000         | mov                 eax, dword ptr [ebp + 0x139]
            //   03c1                 | add                 eax, ecx

        $sequence_9 = { ff5541 50 ff5569 8bf0 }
            // n = 4, score = 500
            //   ff5541               | call                dword ptr [ebp + 0x41]
            //   50                   | push                eax
            //   ff5569               | call                dword ptr [ebp + 0x69]
            //   8bf0                 | mov                 esi, eax

    condition:
        7 of them and filesize < 73728
}