rule win_terra_stealer_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.terra_stealer."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.terra_stealer"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 85c0 0f8523030000 488b0f 4885c9 7405 e8???????? 4180fc05 }
            // n = 7, score = 100
            //   85c0                 | xorps               xmm0, xmm0
            //   0f8523030000         | inc                 ebp
            //   488b0f               | mov                 ebp, dword ptr [ebp + 0xc]
            //   4885c9               | inc                 esp
            //   7405                 | mov                 dword ptr [esp + 0x34], ebp
            //   e8????????           |                     
            //   4180fc05             | inc                 ecx

        $sequence_1 = { e8???????? 488983f0120000 4885c0 7456 41b80f000000 488d15302f0900 488bcb }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488983f0120000       | dec                 eax
            //   4885c0               | mov                 eax, dword ptr [esi + 0x18]
            //   7456                 | dec                 eax
            //   41b80f000000         | lea                 edx, [ecx + ecx*2]
            //   488d15302f0900       | dec                 eax
            //   488bcb               | mov                 ecx, dword ptr [eax + 8]

        $sequence_2 = { eb04 4c8b7d28 4533c9 4533c0 488d1525861d00 488d4c2478 ff15???????? }
            // n = 7, score = 100
            //   eb04                 | dec                 eax
            //   4c8b7d28             | mov                 ecx, eax
            //   4533c9               | dec                 ecx
            //   4533c0               | cmp                 dword ptr [edi + 0x18], 0xf
            //   488d1525861d00       | jbe                 0xddc
            //   488d4c2478           | dec                 ebp
            //   ff15????????         |                     

        $sequence_3 = { ffca 84c0 7425 8bc8 410fb600 420fb6843840061f00 4238843940061f00 }
            // n = 7, score = 100
            //   ffca                 | dec                 esp
            //   84c0                 | mov                 dword ptr [ebp - 0x40], esp
            //   7425                 | dec                 eax
            //   8bc8                 | cmp                 dword ptr [ebx + 0x11b8], 0
            //   410fb600             | je                  0x154a
            //   420fb6843840061f00     | dec    eax
            //   4238843940061f00     | mov                 edi, dword ptr [ebx + 0x12f0]

        $sequence_4 = { 0f8c6effffff 4533c9 418b5708 498bc1 8b7e08 85d2 498bcc }
            // n = 7, score = 100
            //   0f8c6effffff         | dec                 eax
            //   4533c9               | mov                 eax, dword ptr [eax + 0x50]
            //   418b5708             | dec                 ecx
            //   498bc1               | mov                 eax, esp
            //   8b7e08               | dec                 ecx
            //   85d2                 | mov                 dword ptr [ebx - 0x58], eax
            //   498bcc               | dec                 eax

        $sequence_5 = { ffc0 84c9 75e9 4863c8 4881f9f4010000 0f8339070000 488d8550010000 }
            // n = 7, score = 100
            //   ffc0                 | mov                 dword ptr [esp + 0x20], eax
            //   84c9                 | inc                 ecx
            //   75e9                 | mov                 ecx, 0x137a1
            //   4863c8               | dec                 esp
            //   4881f9f4010000       | lea                 eax, [0x19cb4c]
            //   0f8339070000         | dec                 eax
            //   488d8550010000       | lea                 edx, [0x19cb25]

        $sequence_6 = { eb24 498b4e10 4885c9 7415 0f1f00 8b4164 2403 }
            // n = 7, score = 100
            //   eb24                 | mov                 ecx, esi
            //   498b4e10             | dec                 eax
            //   4885c9               | test                eax, eax
            //   7415                 | jne                 0x9d0
            //   0f1f00               | mov                 edx, 0x15
            //   8b4164               | inc                 ecx
            //   2403                 | mov                 eax, 3

        $sequence_7 = { eb07 896b2c c6430144 488bc3 488b5c2478 4883c430 415d }
            // n = 7, score = 100
            //   eb07                 | mov                 edx, dword ptr [esp + 0x30]
            //   896b2c               | lea                 eax, [ecx + 1]
            //   c6430144             | mov                 dword ptr [ebx + 0x90], eax
            //   488bc3               | dec                 eax
            //   488b5c2478           | mov                 ecx, ebx
            //   4883c430             | inc                 ebp
            //   415d                 | test                ah, ah

        $sequence_8 = { e9???????? 488d8ae80f0000 e9???????? 488d8a00100000 e9???????? 488d8a18100000 e9???????? }
            // n = 7, score = 100
            //   e9????????           |                     
            //   488d8ae80f0000       | pop                 ebp
            //   e9????????           |                     
            //   488d8a00100000       | inc                 ecx
            //   e9????????           |                     
            //   488d8a18100000       | pop                 esp
            //   e9????????           |                     

        $sequence_9 = { e9???????? 488b5308 488d05d334f3ff 48ff42f8 4c8b4318 488b3b 4981f8ffffff7f }
            // n = 7, score = 100
            //   e9????????           |                     
            //   488b5308             | dec                 eax
            //   488d05d334f3ff       | mov                 eax, dword ptr [edi + 0x88]
            //   48ff42f8             | mov                 word ptr [eax + ecx*8 - 0x16], 1
            //   4c8b4318             | dec                 eax
            //   488b3b               | mov                 eax, dword ptr [edi]
            //   4981f8ffffff7f       | mov                 edx, dword ptr [edi + 0x90]

    condition:
        7 of them and filesize < 4621312
}