rule win_teslacrypt_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.teslacrypt."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.teslacrypt"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 31f7 897d04 31f9 894d08 }
            // n = 4, score = 900
            //   31f7                 | xor                 edi, esi
            //   897d04               | mov                 dword ptr [ebp + 4], edi
            //   31f9                 | xor                 ecx, edi
            //   894d08               | mov                 dword ptr [ebp + 8], ecx

        $sequence_1 = { 31f7 89bdc4000000 31f9 898dc8000000 31ca 8995cc000000 89d0 }
            // n = 7, score = 900
            //   31f7                 | xor                 edi, esi
            //   89bdc4000000         | mov                 dword ptr [ebp + 0xc4], edi
            //   31f9                 | xor                 ecx, edi
            //   898dc8000000         | mov                 dword ptr [ebp + 0xc8], ecx
            //   31ca                 | xor                 edx, ecx
            //   8995cc000000         | mov                 dword ptr [ebp + 0xcc], edx
            //   89d0                 | mov                 eax, edx

        $sequence_2 = { 31f9 894d08 31ca 89550c 89d0 }
            // n = 5, score = 900
            //   31f9                 | xor                 ecx, edi
            //   894d08               | mov                 dword ptr [ebp + 8], ecx
            //   31ca                 | xor                 edx, ecx
            //   89550c               | mov                 dword ptr [ebp + 0xc], edx
            //   89d0                 | mov                 eax, edx

        $sequence_3 = { 33451c 89453c 51 52 89f2 c1c808 0fb6c8 }
            // n = 7, score = 900
            //   33451c               | xor                 eax, dword ptr [ebp + 0x1c]
            //   89453c               | mov                 dword ptr [ebp + 0x3c], eax
            //   51                   | push                ecx
            //   52                   | push                edx
            //   89f2                 | mov                 edx, esi
            //   c1c808               | ror                 eax, 8
            //   0fb6c8               | movzx               ecx, al

        $sequence_4 = { 31f7 89bda4000000 31f9 898da8000000 31ca 8995ac000000 89d0 }
            // n = 7, score = 900
            //   31f7                 | xor                 edi, esi
            //   89bda4000000         | mov                 dword ptr [ebp + 0xa4], edi
            //   31f9                 | xor                 ecx, edi
            //   898da8000000         | mov                 dword ptr [ebp + 0xa8], ecx
            //   31ca                 | xor                 edx, ecx
            //   8995ac000000         | mov                 dword ptr [ebp + 0xac], edx
            //   89d0                 | mov                 eax, edx

        $sequence_5 = { 3345f4 894514 3345f8 894518 3345fc 89451c 51 }
            // n = 7, score = 900
            //   3345f4               | xor                 eax, dword ptr [ebp - 0xc]
            //   894514               | mov                 dword ptr [ebp + 0x14], eax
            //   3345f8               | xor                 eax, dword ptr [ebp - 8]
            //   894518               | mov                 dword ptr [ebp + 0x18], eax
            //   3345fc               | xor                 eax, dword ptr [ebp - 4]
            //   89451c               | mov                 dword ptr [ebp + 0x1c], eax
            //   51                   | push                ecx

        $sequence_6 = { 335d04 334d08 33550c 81ffa0000000 0f8452030000 81ffc0000000 0f84ac010000 }
            // n = 7, score = 900
            //   335d04               | xor                 ebx, dword ptr [ebp + 4]
            //   334d08               | xor                 ecx, dword ptr [ebp + 8]
            //   33550c               | xor                 edx, dword ptr [ebp + 0xc]
            //   81ffa0000000         | cmp                 edi, 0xa0
            //   0f8452030000         | je                  0x358
            //   81ffc0000000         | cmp                 edi, 0xc0
            //   0f84ac010000         | je                  0x1b2

        $sequence_7 = { 334500 335d04 8b6c2418 894500 895d04 897508 897d0c }
            // n = 7, score = 900
            //   334500               | xor                 eax, dword ptr [ebp]
            //   335d04               | xor                 ebx, dword ptr [ebp + 4]
            //   8b6c2418             | mov                 ebp, dword ptr [esp + 0x18]
            //   894500               | mov                 dword ptr [ebp], eax
            //   895d04               | mov                 dword ptr [ebp + 4], ebx
            //   897508               | mov                 dword ptr [ebp + 8], esi
            //   897d0c               | mov                 dword ptr [ebp + 0xc], edi

        $sequence_8 = { 83fa00 89442418 894c2414 89542410 7d23 8b442410 }
            // n = 6, score = 100
            //   83fa00               | cmp                 edx, 0
            //   89442418             | mov                 dword ptr [esp + 0x18], eax
            //   894c2414             | mov                 dword ptr [esp + 0x14], ecx
            //   89542410             | mov                 dword ptr [esp + 0x10], edx
            //   7d23                 | jge                 0x25
            //   8b442410             | mov                 eax, dword ptr [esp + 0x10]

        $sequence_9 = { 8b54244c 8916 c7460804000000 89442448 ffd1 83ec10 8b4c2448 }
            // n = 7, score = 100
            //   8b54244c             | mov                 edx, dword ptr [esp + 0x4c]
            //   8916                 | mov                 dword ptr [esi], edx
            //   c7460804000000       | mov                 dword ptr [esi + 8], 4
            //   89442448             | mov                 dword ptr [esp + 0x48], eax
            //   ffd1                 | call                ecx
            //   83ec10               | sub                 esp, 0x10
            //   8b4c2448             | mov                 ecx, dword ptr [esp + 0x48]

        $sequence_10 = { 8b442438 c70001000000 8b442428 c70002000000 }
            // n = 4, score = 100
            //   8b442438             | mov                 eax, dword ptr [esp + 0x38]
            //   c70001000000         | mov                 dword ptr [eax], 1
            //   8b442428             | mov                 eax, dword ptr [esp + 0x28]
            //   c70002000000         | mov                 dword ptr [eax], 2

        $sequence_11 = { 894c243c 74b0 e8???????? 89e1 8901 c74104???????? e8???????? }
            // n = 7, score = 100
            //   894c243c             | mov                 dword ptr [esp + 0x3c], ecx
            //   74b0                 | je                  0xffffffb2
            //   e8????????           |                     
            //   89e1                 | mov                 ecx, esp
            //   8901                 | mov                 dword ptr [ecx], eax
            //   c74104????????       |                     
            //   e8????????           |                     

        $sequence_12 = { 8b4c2460 ffd1 83ec08 8944240c }
            // n = 4, score = 100
            //   8b4c2460             | mov                 ecx, dword ptr [esp + 0x60]
            //   ffd1                 | call                ecx
            //   83ec08               | sub                 esp, 8
            //   8944240c             | mov                 dword ptr [esp + 0xc], eax

        $sequence_13 = { 8b4c2434 8b11 8b742438 29d6 8b7c243c }
            // n = 5, score = 100
            //   8b4c2434             | mov                 ecx, dword ptr [esp + 0x34]
            //   8b11                 | mov                 edx, dword ptr [ecx]
            //   8b742438             | mov                 esi, dword ptr [esp + 0x38]
            //   29d6                 | sub                 esi, edx
            //   8b7c243c             | mov                 edi, dword ptr [esp + 0x3c]

        $sequence_14 = { e8???????? 31c9 89c2 83c218 }
            // n = 4, score = 100
            //   e8????????           |                     
            //   31c9                 | xor                 ecx, ecx
            //   89c2                 | mov                 edx, eax
            //   83c218               | add                 edx, 0x18

        $sequence_15 = { 89442408 885c2407 88742406 7428 8b442408 83c001 }
            // n = 6, score = 100
            //   89442408             | mov                 dword ptr [esp + 8], eax
            //   885c2407             | mov                 byte ptr [esp + 7], bl
            //   88742406             | mov                 byte ptr [esp + 6], dh
            //   7428                 | je                  0x2a
            //   8b442408             | mov                 eax, dword ptr [esp + 8]
            //   83c001               | add                 eax, 1

    condition:
        7 of them and filesize < 1187840
}