rule win_tetra_loader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.tetra_loader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tetra_loader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 440fb74204 4181f074350000 4109c8 0f8480050000 3302 0fb74a04 81f174360000 }
            // n = 7, score = 100
            //   440fb74204           | test                cl, 3
            //   4181f074350000       | inc                 ecx
            //   4109c8               | mov                 eax, 0x700
            //   0f8480050000         | dec                 ebp
            //   3302                 | lea                 ebx, [ecx + 0x88]
            //   0fb74a04             | dec                 ecx
            //   81f174360000         | cmp                 ebx, edx

        $sequence_1 = { 66f7e6 0f8010010000 89c2 6601ea 410f92c6 31c0 81fdffff0000 }
            // n = 7, score = 100
            //   66f7e6               | test                bx, bx
            //   0f8010010000         | je                  0x54e
            //   89c2                 | mov                 word ptr [edx + 0x10], 0
            //   6601ea               | dec                 esp
            //   410f92c6             | mov                 edi, dword ptr [edx]
            //   31c0                 | dec                 esp
            //   81fdffff0000         | mov                 esi, dword ptr [edx + 8]

        $sequence_2 = { e8???????? 0f0b 4c8d059f8a0100 b901000000 4c89d2 e8???????? 0f0b }
            // n = 7, score = 100
            //   e8????????           |                     
            //   0f0b                 | test                ecx, ecx
            //   4c8d059f8a0100       | ud2                 
            //   b901000000           | dec                 eax
            //   4c89d2               | sub                 esp, 0x58
            //   e8????????           |                     
            //   0f0b                 | dec                 eax

        $sequence_3 = { 4531db 81f9ffff0000 7715 6666666666662e0f1f840000000000 41bc03000000 4c89f2 }
            // n = 6, score = 100
            //   4531db               | add                 edi, 4
            //   81f9ffff0000         | inc                 ecx
            //   7715                 | and                 esp, 0x3f
            //   6666666666662e0f1f840000000000     | inc    ebp
            //   41bc03000000         | or                  esp, ebp
            //   4c89f2               | inc                 eax

        $sequence_4 = { 7521 c6851717000000 488d8db8160000 488d154ce70200 e8???????? 488bb5c0160000 66c746023b00 }
            // n = 7, score = 100
            //   7521                 | mov                 edi, 0xffffffff
            //   c6851717000000       | jmp                 0x1ae
            //   488d8db8160000       | jne                 0x19d
            //   488d154ce70200       | inc                 eax
            //   e8????????           |                     
            //   488bb5c0160000       | mov                 dh, 1
            //   66c746023b00         | mov                 bl, 2

        $sequence_5 = { 48ffc7 4c89f0 4d89fb bd00000000 4885c0 0f856bffffff ebb4 }
            // n = 7, score = 100
            //   48ffc7               | lea                 eax, [ebp + 0x40]
            //   4c89f0               | dec                 eax
            //   4d89fb               | mov                 dword ptr [ebp], eax
            //   bd00000000           | xorps               xmm0, xmm0
            //   4885c0               | movups              xmmword ptr [ebp + 8], xmm0
            //   0f856bffffff         | dec                 eax
            //   ebb4                 | lea                 ecx, [ebp + 0x38]

        $sequence_6 = { 488901 b001 f6c201 7513 488b4110 488b4820 488b4028 }
            // n = 7, score = 100
            //   488901               | xor                 eax, eax
            //   b001                 | inc                 ebp
            //   f6c201               | xor                 esp, esp
            //   7513                 | dec                 eax
            //   488b4110             | test                esi, esi
            //   488b4820             | je                  0x34e
            //   488b4028             | dec                 esp

        $sequence_7 = { 483b7df0 75bc eb8d 4489e1 83e11f 450fb64701 4183e03f }
            // n = 7, score = 100
            //   483b7df0             | dec                 ecx
            //   75bc                 | mov                 esp, ecx
            //   eb8d                 | inc                 ecx
            //   4489e1               | mov                 ebp, 0xa
            //   83e11f               | dec                 ecx
            //   450fb64701           | mov                 ecx, dword ptr [esp + 0x20]
            //   4183e03f             | dec                 ebp

        $sequence_8 = { 4883c1fe 3d00010000 89d0 73a1 0fb64500 8845d0 0f2845e0 }
            // n = 7, score = 100
            //   4883c1fe             | inc                 ecx
            //   3d00010000           | movzx               edi, byte ptr [eax + ebp + 1]
            //   89d0                 | dec                 eax
            //   73a1                 | cmp                 eax, edi
            //   0fb64500             | jne                 0x7db
            //   8845d0               | dec                 eax
            //   0f2845e0             | mov                 dword ptr [esi + 8], 1

        $sequence_9 = { 488b4de8 48c744243000000000 c744242880000000 c744242003000000 ba00000080 41b801000000 4531c9 }
            // n = 7, score = 100
            //   488b4de8             | mov                 ecx, dword ptr [ebp + 0x28]
            //   48c744243000000000     | cmp    byte ptr [ecx + 2], 0xbf
            //   c744242880000000     | dec                 ecx
            //   c744242003000000     | mov                 esi, eax
            //   ba00000080           | jg                  0xf7
            //   41b801000000         | dec                 eax
            //   4531c9               | mov                 ecx, dword ptr [ebp + 0x28]

    condition:
        7 of them and filesize < 847872
}