rule win_tflower_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.tflower."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tflower"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0001 0200 0103 0303 }
            // n = 4, score = 200
            //   0001                 | add                 byte ptr [ecx], al
            //   0200                 | add                 al, byte ptr [eax]
            //   0103                 | add                 dword ptr [ebx], eax
            //   0303                 | add                 eax, dword ptr [ebx]

        $sequence_1 = { 000f 7708 0001 7708 }
            // n = 4, score = 200
            //   000f                 | add                 byte ptr [edi], cl
            //   7708                 | ja                  0xa
            //   0001                 | add                 byte ptr [ecx], al
            //   7708                 | ja                  0xa

        $sequence_2 = { 0002 7408 00f7 7308 }
            // n = 4, score = 200
            //   0002                 | add                 byte ptr [edx], al
            //   7408                 | je                  0xa
            //   00f7                 | add                 bh, dh
            //   7308                 | jae                 0xa

        $sequence_3 = { 89442414 8b06 83f804 0f8728010000 ff2485249d4a00 6a02 6a01 }
            // n = 7, score = 200
            //   89442414             | mov                 dword ptr [esp + 0x14], eax
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   83f804               | cmp                 eax, 4
            //   0f8728010000         | ja                  0x12e
            //   ff2485249d4a00       | jmp                 dword ptr [eax*4 + 0x4a9d24]
            //   6a02                 | push                2
            //   6a01                 | push                1

        $sequence_4 = { 001a 0c05 003c0c 05004e0c05 }
            // n = 4, score = 200
            //   001a                 | add                 byte ptr [edx], bl
            //   0c05                 | or                  al, 5
            //   003c0c               | add                 byte ptr [esp + ecx], bh
            //   05004e0c05           | add                 eax, 0x50c4e00

        $sequence_5 = { 8b148dc0064f00 331485c0024f00 8bc3 c1e808 }
            // n = 4, score = 200
            //   8b148dc0064f00       | mov                 edx, dword ptr [ecx*4 + 0x4f06c0]
            //   331485c0024f00       | xor                 edx, dword ptr [eax*4 + 0x4f02c0]
            //   8bc3                 | mov                 eax, ebx
            //   c1e808               | shr                 eax, 8

        $sequence_6 = { 83fa07 8b542410 775e 8b6c2414 ff24ad9ce34600 0fb679ff }
            // n = 6, score = 200
            //   83fa07               | cmp                 edx, 7
            //   8b542410             | mov                 edx, dword ptr [esp + 0x10]
            //   775e                 | ja                  0x60
            //   8b6c2414             | mov                 ebp, dword ptr [esp + 0x14]
            //   ff24ad9ce34600       | jmp                 dword ptr [ebp*4 + 0x46e39c]
            //   0fb679ff             | movzx               edi, byte ptr [ecx - 1]

        $sequence_7 = { 000b 8605???????? 007885 0500788605 }
            // n = 4, score = 200
            //   000b                 | add                 byte ptr [ebx], cl
            //   8605????????         |                     
            //   007885               | add                 byte ptr [eax - 0x7b], bh
            //   0500788605           | add                 eax, 0x5867800

        $sequence_8 = { 33148520c54e00 33f2 2bde d3c3 8bc3 }
            // n = 5, score = 200
            //   33148520c54e00       | xor                 edx, dword ptr [eax*4 + 0x4ec520]
            //   33f2                 | xor                 esi, edx
            //   2bde                 | sub                 ebx, esi
            //   d3c3                 | rol                 ebx, cl
            //   8bc3                 | mov                 eax, ebx

        $sequence_9 = { 0010 740b 0021 740b }
            // n = 4, score = 200
            //   0010                 | add                 byte ptr [eax], dl
            //   740b                 | je                  0xd
            //   0021                 | add                 byte ptr [ecx], ah
            //   740b                 | je                  0xd

        $sequence_10 = { c745e0787f4b00 e9???????? c745e0647f4b00 e9???????? c745dc02000000 }
            // n = 5, score = 200
            //   c745e0787f4b00       | mov                 dword ptr [ebp - 0x20], 0x4b7f78
            //   e9????????           |                     
            //   c745e0647f4b00       | mov                 dword ptr [ebp - 0x20], 0x4b7f64
            //   e9????????           |                     
            //   c745dc02000000       | mov                 dword ptr [ebp - 0x24], 2

        $sequence_11 = { 0001 7708 00f3 7608 }
            // n = 4, score = 200
            //   0001                 | add                 byte ptr [ecx], al
            //   7708                 | ja                  0xa
            //   00f3                 | add                 bl, dh
            //   7608                 | jbe                 0xa

        $sequence_12 = { 0008 7408 0002 7408 }
            // n = 4, score = 200
            //   0008                 | add                 byte ptr [eax], cl
            //   7408                 | je                  0xa
            //   0002                 | add                 byte ptr [edx], al
            //   7408                 | je                  0xa

        $sequence_13 = { c1e818 8b4d2c c1eb10 03148520c14e00 0fb6c3 8b5d28 }
            // n = 6, score = 200
            //   c1e818               | shr                 eax, 0x18
            //   8b4d2c               | mov                 ecx, dword ptr [ebp + 0x2c]
            //   c1eb10               | shr                 ebx, 0x10
            //   03148520c14e00       | add                 edx, dword ptr [eax*4 + 0x4ec120]
            //   0fb6c3               | movzx               eax, bl
            //   8b5d28               | mov                 ebx, dword ptr [ebp + 0x28]

        $sequence_14 = { 0fb6c0 8b0c8d20ed4e00 330c8520f14e00 8bc3 c1e818 c1eb10 }
            // n = 6, score = 200
            //   0fb6c0               | movzx               eax, al
            //   8b0c8d20ed4e00       | mov                 ecx, dword ptr [ecx*4 + 0x4eed20]
            //   330c8520f14e00       | xor                 ecx, dword ptr [eax*4 + 0x4ef120]
            //   8bc3                 | mov                 eax, ebx
            //   c1e818               | shr                 eax, 0x18
            //   c1eb10               | shr                 ebx, 0x10

        $sequence_15 = { 0fbec0 8d89f8feffff 8d0c48 3b0c95788f4f00 }
            // n = 4, score = 200
            //   0fbec0               | movsx               eax, al
            //   8d89f8feffff         | lea                 ecx, [ecx - 0x108]
            //   8d0c48               | lea                 ecx, [eax + ecx*2]
            //   3b0c95788f4f00       | cmp                 ecx, dword ptr [edx*4 + 0x4f8f78]

    condition:
        7 of them and filesize < 6578176
}