rule win_thunker_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.thunker."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.thunker"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 7505 e9???????? ffb5fcfdffff e8???????? 68???????? 8d8500feffff }
            // n = 6, score = 100
            //   7505                 | jne                 7
            //   e9????????           |                     
            //   ffb5fcfdffff         | push                dword ptr [ebp - 0x204]
            //   e8????????           |                     
            //   68????????           |                     
            //   8d8500feffff         | lea                 eax, [ebp - 0x200]

        $sequence_1 = { e8???????? 8d8500feffff 50 e8???????? 8d8500feffff 50 68???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   8d8500feffff         | lea                 eax, [ebp - 0x200]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8d8500feffff         | lea                 eax, [ebp - 0x200]
            //   50                   | push                eax
            //   68????????           |                     

        $sequence_2 = { 7417 e9???????? 3de7710000 7433 7c79 }
            // n = 5, score = 100
            //   7417                 | je                  0x19
            //   e9????????           |                     
            //   3de7710000           | cmp                 eax, 0x71e7
            //   7433                 | je                  0x35
            //   7c79                 | jl                  0x7b

        $sequence_3 = { 8d0556412600 8945fc a1???????? 8945e8 8d05a02a2600 8945dc 8365f000 }
            // n = 7, score = 100
            //   8d0556412600         | lea                 eax, [0x264156]
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   a1????????           |                     
            //   8945e8               | mov                 dword ptr [ebp - 0x18], eax
            //   8d05a02a2600         | lea                 eax, [0x262aa0]
            //   8945dc               | mov                 dword ptr [ebp - 0x24], eax
            //   8365f000             | and                 dword ptr [ebp - 0x10], 0

        $sequence_4 = { e8???????? 83c40c 09c0 750d }
            // n = 4, score = 100
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   09c0                 | or                  eax, eax
            //   750d                 | jne                 0xf

        $sequence_5 = { e8???????? 6a06 53 e8???????? 83c410 eb40 6a04 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   6a06                 | push                6
            //   53                   | push                ebx
            //   e8????????           |                     
            //   83c410               | add                 esp, 0x10
            //   eb40                 | jmp                 0x42
            //   6a04                 | push                4

        $sequence_6 = { 09c0 743b 6a00 6800100000 8d85fceeffff 50 ffb5e0edffff }
            // n = 7, score = 100
            //   09c0                 | or                  eax, eax
            //   743b                 | je                  0x3d
            //   6a00                 | push                0
            //   6800100000           | push                0x1000
            //   8d85fceeffff         | lea                 eax, [ebp - 0x1104]
            //   50                   | push                eax
            //   ffb5e0edffff         | push                dword ptr [ebp - 0x1220]

        $sequence_7 = { c6843d00feffff00 09ff 7405 83ffff 7502 eb48 }
            // n = 6, score = 100
            //   c6843d00feffff00     | mov                 byte ptr [ebp + edi - 0x200], 0
            //   09ff                 | or                  edi, edi
            //   7405                 | je                  7
            //   83ffff               | cmp                 edi, -1
            //   7502                 | jne                 4
            //   eb48                 | jmp                 0x4a

        $sequence_8 = { 83c40c 8d8544edffff 50 e8???????? 8985c4edffff }
            // n = 5, score = 100
            //   83c40c               | add                 esp, 0xc
            //   8d8544edffff         | lea                 eax, [ebp - 0x12bc]
            //   50                   | push                eax
            //   e8????????           |                     
            //   8985c4edffff         | mov                 dword ptr [ebp - 0x123c], eax

        $sequence_9 = { 89e5 51 56 57 8b7d08 ff750c }
            // n = 6, score = 100
            //   89e5                 | mov                 ebp, esp
            //   51                   | push                ecx
            //   56                   | push                esi
            //   57                   | push                edi
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   ff750c               | push                dword ptr [ebp + 0xc]

    condition:
        7 of them and filesize < 73728
}