rule win_tiger_rat_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.tiger_rat."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tiger_rat"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4883fbff 7425 48c74108ffffffff ba02000000 488bcb }
            // n = 5, score = 200
            //   4883fbff             | dec                 esp
            //   7425                 | arpl                bp, ax
            //   48c74108ffffffff     | inc                 esp
            //   ba02000000           | sub                 esp, edi
            //   488bcb               | dec                 eax

        $sequence_1 = { 4883f8ff 740c 83caff 488bc8 ff15???????? 33c0 }
            // n = 6, score = 200
            //   4883f8ff             | dec                 eax
            //   740c                 | mov                 ecx, ebx
            //   83caff               | movzx               eax, word ptr [ebp - 0x52]
            //   488bc8               | jne                 0xf
            //   ff15????????         |                     
            //   33c0                 | dec                 ecx

        $sequence_2 = { 41b831000000 48895c2420 e8???????? 488bcb }
            // n = 4, score = 200
            //   41b831000000         | dec                 eax
            //   48895c2420           | cmp                 eax, -1
            //   e8????????           |                     
            //   488bcb               | je                  0xe

        $sequence_3 = { 33d2 41b800020000 e8???????? c7832804000020000000 89bb30040000 48c7834c04000000000000 }
            // n = 6, score = 200
            //   33d2                 | xor                 edx, edx
            //   41b800020000         | inc                 ecx
            //   e8????????           |                     
            //   c7832804000020000000     | mov    eax, 0x200
            //   89bb30040000         | mov                 dword ptr [ebx + 0x428], 0x20
            //   48c7834c04000000000000     | mov    dword ptr [ebx + 0x430], edi

        $sequence_4 = { 0fb745ae 663b0d???????? 750d 663b05???????? }
            // n = 4, score = 200
            //   0fb745ae             | mov                 ecx, esi
            //   663b0d????????       |                     
            //   750d                 | dec                 eax
            //   663b05????????       |                     

        $sequence_5 = { 381a 7505 448bc3 eb11 4983c8ff 0f1f4000 }
            // n = 6, score = 200
            //   381a                 | shr                 ebx, 4
            //   7505                 | shl                 cl, 4
            //   448bc3               | or                  al, cl
            //   eb11                 | inc                 ecx
            //   4983c8ff             | movzx               ecx, bh
            //   0f1f4000             | or                  byte ptr [ebp - 0x2a], al

        $sequence_6 = { 2bef 488bcb 4c63c5 e8???????? 442be7 488bce }
            // n = 6, score = 200
            //   2bef                 | dec                 eax
            //   488bcb               | mov                 dword ptr [ebx + 0x44c], 0
            //   4c63c5               | sub                 ebp, edi
            //   e8????????           |                     
            //   442be7               | dec                 eax
            //   488bce               | mov                 ecx, ebx

        $sequence_7 = { 49c1eb04 c0e104 0ac1 410fb6cf 0845d6 }
            // n = 5, score = 200
            //   49c1eb04             | cmp                 ebx, -1
            //   c0e104               | je                  0x27
            //   0ac1                 | dec                 eax
            //   410fb6cf             | mov                 dword ptr [ecx + 8], 0xffffffff
            //   0845d6               | mov                 edx, 2

        $sequence_8 = { 415f 5e c3 8b5650 33c9 41b800100000 }
            // n = 6, score = 100
            //   415f                 | dec                 esp
            //   5e                   | mov                 ecx, eax
            //   c3                   | dec                 eax
            //   8b5650               | mov                 ebp, esp
            //   33c9                 | dec                 eax
            //   41b800100000         | sub                 esp, 0x20

        $sequence_9 = { 4898 483de4000000 730f 488d0d1d840000 4803c0 8b04c1 eb02 }
            // n = 7, score = 100
            //   4898                 | dec                 eax
            //   483de4000000         | mov                 ecx, ebx
            //   730f                 | dec                 esp
            //   488d0d1d840000       | lea                 eax, [0xfffff8f8]
            //   4803c0               | xor                 edx, edx
            //   8b04c1               | mov                 dword ptr [eax], ebx
            //   eb02                 | xor                 ebx, ebx

        $sequence_10 = { 8b4e28 4803cf e8???????? 488bbc24c0000000 }
            // n = 4, score = 100
            //   8b4e28               | dec                 ecx
            //   4803cf               | or                  eax, 0xffffffff
            //   e8????????           |                     
            //   488bbc24c0000000     | nop                 dword ptr [eax]

        $sequence_11 = { f30f7f4507 0b0d???????? 41b8d0070000 c745f74008027b }
            // n = 4, score = 100
            //   f30f7f4507           | dec                 eax
            //   0b0d????????         |                     
            //   41b8d0070000         | mov                 ecx, eax
            //   c745f74008027b       | dec                 eax

        $sequence_12 = { 488bdf 48c1fb05 4c8d353a1c0100 83e01f 486bf058 }
            // n = 5, score = 100
            //   488bdf               | mov                 ecx, dword ptr [esi + 0x28]
            //   48c1fb05             | dec                 eax
            //   4c8d353a1c0100       | add                 ecx, edi
            //   83e01f               | dec                 eax
            //   486bf058             | mov                 edi, dword ptr [esp + 0xc0]

        $sequence_13 = { 488d1578bd0000 488bcb 488905???????? ff15???????? 488bc8 ff15???????? 488d1570bd0000 }
            // n = 7, score = 100
            //   488d1578bd0000       | inc                 ecx
            //   488bcb               | mov                 eax, 0x31
            //   488905????????       |                     
            //   ff15????????         |                     
            //   488bc8               | dec                 eax
            //   ff15????????         |                     
            //   488d1570bd0000       | mov                 dword ptr [esp + 0x20], ebx

        $sequence_14 = { 0fb64c05b7 48ffc0 42324c05a7 4883f80f }
            // n = 4, score = 100
            //   0fb64c05b7           | dec                 eax
            //   48ffc0               | lea                 edx, [0xbd78]
            //   42324c05a7           | dec                 eax
            //   4883f80f             | mov                 ecx, ebx

        $sequence_15 = { 4c8d2d166e0100 413bff 7d77 488b0e }
            // n = 4, score = 100
            //   4c8d2d166e0100       | dec                 eax
            //   413bff               | mov                 edi, ecx
            //   7d77                 | dec                 eax
            //   488b0e               | mov                 ecx, dword ptr [ecx + 0x18]

    condition:
        7 of them and filesize < 557056
}