rule win_tigerlite_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.tigerlite."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tigerlite"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488bf8 4883f8ff 7520 488d15e1c50100 488bce e8???????? }
            // n = 6, score = 100
            //   488bf8               | mov                 dword ptr [ebp + 0x30], esi
            //   4883f8ff             | mov                 edx, dword ptr [ebp + 0x30]
            //   7520                 | dec                 eax
            //   488d15e1c50100       | mov                 edi, eax
            //   488bce               | dec                 eax
            //   e8????????           |                     

        $sequence_1 = { 4885c0 0f84a9010000 488bc8 ff15???????? 488d1520ad0000 }
            // n = 5, score = 100
            //   4885c0               | cmp                 eax, -1
            //   0f84a9010000         | jne                 0x22
            //   488bc8               | dec                 eax
            //   ff15????????         |                     
            //   488d1520ad0000       | lea                 edx, [0x1c5e1]

        $sequence_2 = { 803c0700 75f7 488d4f01 4d8bce }
            // n = 4, score = 100
            //   803c0700             | je                  0x1b2
            //   75f7                 | dec                 eax
            //   488d4f01             | mov                 ecx, eax
            //   4d8bce               | dec                 eax

        $sequence_3 = { 2bca 8d95e0f9ffff 8d7201 8a02 42 }
            // n = 5, score = 100
            //   2bca                 | sub                 ecx, edx
            //   8d95e0f9ffff         | lea                 edx, [ebp - 0x620]
            //   8d7201               | lea                 esi, [edx + 1]
            //   8a02                 | mov                 al, byte ptr [edx]
            //   42                   | inc                 edx

        $sequence_4 = { 50 e8???????? 83c40c c645f400 833d????????00 c745f500000000 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   c645f400             | mov                 byte ptr [ebp - 0xc], 0
            //   833d????????00       |                     
            //   c745f500000000       | mov                 dword ptr [ebp - 0xb], 0

        $sequence_5 = { e8???????? 4c8d4530 8d5614 488d0defa70100 897530 e8???????? 8b5530 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   4c8d4530             | dec                 esp
            //   8d5614               | lea                 eax, [ebp + 0x30]
            //   488d0defa70100       | lea                 edx, [esi + 0x14]
            //   897530               | dec                 eax
            //   e8????????           |                     
            //   8b5530               | lea                 ecx, [0x1a7ef]

        $sequence_6 = { ff15???????? 8bf8 e9???????? 8b8528e5ffff 8b0c85489d4100 8b8524e5ffff }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   e9????????           |                     
            //   8b8528e5ffff         | mov                 eax, dword ptr [ebp - 0x1ad8]
            //   8b0c85489d4100       | mov                 ecx, dword ptr [eax*4 + 0x419d48]
            //   8b8524e5ffff         | mov                 eax, dword ptr [ebp - 0x1adc]

        $sequence_7 = { 0fbec2 0fbe80d8214100 83e00f eb02 33c0 }
            // n = 5, score = 100
            //   0fbec2               | movsx               eax, dl
            //   0fbe80d8214100       | movsx               eax, byte ptr [eax + 0x4121d8]
            //   83e00f               | and                 eax, 0xf
            //   eb02                 | jmp                 4
            //   33c0                 | xor                 eax, eax

        $sequence_8 = { 8d859cf2ffff 03c1 8b8d24e5ffff 50 8b8528e5ffff 8b0485489d4100 ff3401 }
            // n = 7, score = 100
            //   8d859cf2ffff         | lea                 eax, [ebp - 0xd64]
            //   03c1                 | add                 eax, ecx
            //   8b8d24e5ffff         | mov                 ecx, dword ptr [ebp - 0x1adc]
            //   50                   | push                eax
            //   8b8528e5ffff         | mov                 eax, dword ptr [ebp - 0x1ad8]
            //   8b0485489d4100       | mov                 eax, dword ptr [eax*4 + 0x419d48]
            //   ff3401               | push                dword ptr [ecx + eax]

        $sequence_9 = { 50 8b0495489d4100 ff3418 ff15???????? 85c0 750a }
            // n = 6, score = 100
            //   50                   | push                eax
            //   8b0495489d4100       | mov                 eax, dword ptr [edx*4 + 0x419d48]
            //   ff3418               | push                dword ptr [eax + ebx]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   750a                 | jne                 0xc

        $sequence_10 = { 488bfa 488bd9 488d0549e90000 488981a0000000 83611000 }
            // n = 5, score = 100
            //   488bfa               | dec                 ebp
            //   488bd9               | mov                 ecx, esi
            //   488d0549e90000       | dec                 eax
            //   488981a0000000       | mov                 edi, ecx
            //   83611000             | mov                 byte ptr [esp + 0x28], al

        $sequence_11 = { 8a06 46 88441905 8b45f4 83fa02 7c11 8b0c85489d4100 }
            // n = 7, score = 100
            //   8a06                 | mov                 al, byte ptr [esi]
            //   46                   | inc                 esi
            //   88441905             | mov                 byte ptr [ecx + ebx + 5], al
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   83fa02               | cmp                 edx, 2
            //   7c11                 | jl                  0x13
            //   8b0c85489d4100       | mov                 ecx, dword ptr [eax*4 + 0x419d48]

        $sequence_12 = { ff742414 8b442420 03c6 57 }
            // n = 4, score = 100
            //   ff742414             | push                dword ptr [esp + 0x14]
            //   8b442420             | mov                 eax, dword ptr [esp + 0x20]
            //   03c6                 | add                 eax, esi
            //   57                   | push                edi

        $sequence_13 = { 785b 8bc3 2503000080 7d07 }
            // n = 4, score = 100
            //   785b                 | mov                 eax, 0x400
            //   8bc3                 | dec                 eax
            //   2503000080           | mov                 ecx, eax
            //   7d07                 | cmp                 byte ptr [edi + eax], 0

        $sequence_14 = { 0fb605???????? 488bf9 88442428 e8???????? 4885c0 0f8422010000 }
            // n = 6, score = 100
            //   0fb605????????       |                     
            //   488bf9               | lea                 edx, [0xad20]
            //   88442428             | ret                 
            //   e8????????           |                     
            //   4885c0               | xor                 edx, edx
            //   0f8422010000         | inc                 ecx

        $sequence_15 = { c3 33d2 41b800040000 488bc8 }
            // n = 4, score = 100
            //   c3                   | dec                 eax
            //   33d2                 | mov                 ecx, esi
            //   41b800040000         | dec                 eax
            //   488bc8               | test                eax, eax

    condition:
        7 of them and filesize < 349184
}