rule win_tildeb_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.tildeb."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tildeb"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bbc24e0000000 03fb 03ef 8b3d???????? }
            // n = 4, score = 100
            //   8bbc24e0000000       | mov                 edi, dword ptr [esp + 0xe0]
            //   03fb                 | add                 edi, ebx
            //   03ef                 | add                 ebp, edi
            //   8b3d????????         |                     

        $sequence_1 = { ff15???????? e9???????? 6810270000 8b0d???????? 51 ff15???????? 85c0 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   e9????????           |                     
            //   6810270000           | push                0x2710
            //   8b0d????????         |                     
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

        $sequence_2 = { 83c8ff 5e 81c494010000 c3 b80a000000 5e 81c494010000 }
            // n = 7, score = 100
            //   83c8ff               | or                  eax, 0xffffffff
            //   5e                   | pop                 esi
            //   81c494010000         | add                 esp, 0x194
            //   c3                   | ret                 
            //   b80a000000           | mov                 eax, 0xa
            //   5e                   | pop                 esi
            //   81c494010000         | add                 esp, 0x194

        $sequence_3 = { 8d4c2420 e8???????? 50 ff15???????? 8bf8 83c9ff 33c0 }
            // n = 7, score = 100
            //   8d4c2420             | lea                 ecx, [esp + 0x20]
            //   e8????????           |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8bf8                 | mov                 edi, eax
            //   83c9ff               | or                  ecx, 0xffffffff
            //   33c0                 | xor                 eax, eax

        $sequence_4 = { 50 51 ff15???????? 3d040000c0 7516 8b16 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   51                   | push                ecx
            //   ff15????????         |                     
            //   3d040000c0           | cmp                 eax, 0xc0000004
            //   7516                 | jne                 0x18
            //   8b16                 | mov                 edx, dword ptr [esi]

        $sequence_5 = { b9???????? e8???????? 6a00 6a04 8d85e0f9ffff 50 }
            // n = 6, score = 100
            //   b9????????           |                     
            //   e8????????           |                     
            //   6a00                 | push                0
            //   6a04                 | push                4
            //   8d85e0f9ffff         | lea                 eax, [ebp - 0x620]
            //   50                   | push                eax

        $sequence_6 = { 8d85e4f9ffff 50 6800040000 ff15???????? 8d8de0f5ffff 51 6a00 }
            // n = 7, score = 100
            //   8d85e4f9ffff         | lea                 eax, [ebp - 0x61c]
            //   50                   | push                eax
            //   6800040000           | push                0x400
            //   ff15????????         |                     
            //   8d8de0f5ffff         | lea                 ecx, [ebp - 0xa20]
            //   51                   | push                ecx
            //   6a00                 | push                0

        $sequence_7 = { 33dd 8bac24d0000000 899c24ec000000 8b9c24e4000000 33dd 8bac24b8000000 33dd }
            // n = 7, score = 100
            //   33dd                 | xor                 ebx, ebp
            //   8bac24d0000000       | mov                 ebp, dword ptr [esp + 0xd0]
            //   899c24ec000000       | mov                 dword ptr [esp + 0xec], ebx
            //   8b9c24e4000000       | mov                 ebx, dword ptr [esp + 0xe4]
            //   33dd                 | xor                 ebx, ebp
            //   8bac24b8000000       | mov                 ebp, dword ptr [esp + 0xb8]
            //   33dd                 | xor                 ebx, ebp

        $sequence_8 = { 89442460 8b442454 8d4c2458 33f0 51 89742468 e8???????? }
            // n = 7, score = 100
            //   89442460             | mov                 dword ptr [esp + 0x60], eax
            //   8b442454             | mov                 eax, dword ptr [esp + 0x54]
            //   8d4c2458             | lea                 ecx, [esp + 0x58]
            //   33f0                 | xor                 esi, eax
            //   51                   | push                ecx
            //   89742468             | mov                 dword ptr [esp + 0x68], esi
            //   e8????????           |                     

        $sequence_9 = { 85c0 7507 c605????????01 68???????? 68???????? 8b3d???????? ffd7 }
            // n = 7, score = 100
            //   85c0                 | test                eax, eax
            //   7507                 | jne                 9
            //   c605????????01       |                     
            //   68????????           |                     
            //   68????????           |                     
            //   8b3d????????         |                     
            //   ffd7                 | call                edi

    condition:
        7 of them and filesize < 8532488
}