rule win_tinba_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.tinba."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tinba"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b7508 ad 50 56 }
            // n = 4, score = 1100
            //   8b7508               | mov                 esi, dword ptr [ebp + 8]
            //   ad                   | lodsd               eax, dword ptr [esi]
            //   50                   | push                eax
            //   56                   | push                esi

        $sequence_1 = { 8b4510 aa 8b450c ab }
            // n = 4, score = 1100
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   aa                   | stosb               byte ptr es:[edi], al
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   ab                   | stosd               dword ptr es:[edi], eax

        $sequence_2 = { 6a00 6a00 ff750c 6a00 6a00 ff7508 }
            // n = 6, score = 1000
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   ff7508               | push                dword ptr [ebp + 8]

        $sequence_3 = { 8a241f 88240f 88041f 41 }
            // n = 4, score = 1000
            //   8a241f               | mov                 ah, byte ptr [edi + ebx]
            //   88240f               | mov                 byte ptr [edi + ecx], ah
            //   88041f               | mov                 byte ptr [edi + ebx], al
            //   41                   | inc                 ecx

        $sequence_4 = { 7416 66b80d0a 66ab b8436f6f6b ab b869653a20 }
            // n = 6, score = 900
            //   7416                 | je                  0x18
            //   66b80d0a             | mov                 ax, 0xa0d
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   b8436f6f6b           | mov                 eax, 0x6b6f6f43
            //   ab                   | stosd               dword ptr es:[edi], eax
            //   b869653a20           | mov                 eax, 0x203a6569

        $sequence_5 = { 7437 b912000000 48 8d3db0010000 807a180f }
            // n = 5, score = 900
            //   7437                 | je                  0x39
            //   b912000000           | mov                 ecx, 0x12
            //   48                   | dec                 eax
            //   8d3db0010000         | lea                 edi, [0x1b0]
            //   807a180f             | cmp                 byte ptr [edx + 0x18], 0xf

        $sequence_6 = { 72ee 87ce 89f8 29ce f3a4 29fe }
            // n = 6, score = 900
            //   72ee                 | jb                  0xfffffff0
            //   87ce                 | xchg                esi, ecx
            //   89f8                 | mov                 eax, edi
            //   29ce                 | sub                 esi, ecx
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   29fe                 | sub                 esi, edi

        $sequence_7 = { bb0a000000 31d2 f7f3 52 41 }
            // n = 5, score = 900
            //   bb0a000000           | mov                 ebx, 0xa
            //   31d2                 | xor                 edx, edx
            //   f7f3                 | div                 ebx
            //   52                   | push                edx
            //   41                   | inc                 ecx

        $sequence_8 = { 3c0a 7304 0430 eb02 0437 aa c14d0804 }
            // n = 7, score = 900
            //   3c0a                 | cmp                 al, 0xa
            //   7304                 | jae                 6
            //   0430                 | add                 al, 0x30
            //   eb02                 | jmp                 4
            //   0437                 | add                 al, 0x37
            //   aa                   | stosb               byte ptr es:[edi], al
            //   c14d0804             | ror                 dword ptr [ebp + 8], 4

        $sequence_9 = { 40 eb12 ff7514 ff7510 ff750c }
            // n = 5, score = 900
            //   40                   | inc                 eax
            //   eb12                 | jmp                 0x14
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   ff750c               | push                dword ptr [ebp + 0xc]

        $sequence_10 = { 85c0 741b 66b80d0a 66ab b855736572 }
            // n = 5, score = 900
            //   85c0                 | test                eax, eax
            //   741b                 | je                  0x1d
            //   66b80d0a             | mov                 ax, 0xa0d
            //   66ab                 | stosw               word ptr es:[edi], ax
            //   b855736572           | mov                 eax, 0x72657355

        $sequence_11 = { 8d7a33 f6c304 740a 834a3540 66a5 }
            // n = 5, score = 900
            //   8d7a33               | lea                 edi, [edx + 0x33]
            //   f6c304               | test                bl, 4
            //   740a                 | je                  0xc
            //   834a3540             | or                  dword ptr [edx + 0x35], 0x40
            //   66a5                 | movsw               word ptr es:[edi], word ptr [esi]

        $sequence_12 = { 8b0e 3b4d10 7603 8b4d10 51 57 ff750c }
            // n = 7, score = 900
            //   8b0e                 | mov                 ecx, dword ptr [esi]
            //   3b4d10               | cmp                 ecx, dword ptr [ebp + 0x10]
            //   7603                 | jbe                 5
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   51                   | push                ecx
            //   57                   | push                edi
            //   ff750c               | push                dword ptr [ebp + 0xc]

    condition:
        7 of them and filesize < 57344
}