rule win_tinyfluff_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.tinyfluff."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tinyfluff"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 51 50 51 ffb5dcfbffff 8d8d74fbffff e8???????? 8d8590fbffff }
            // n = 7, score = 200
            //   51                   | push                ecx
            //   50                   | push                eax
            //   51                   | push                ecx
            //   ffb5dcfbffff         | push                dword ptr [ebp - 0x424]
            //   8d8d74fbffff         | lea                 ecx, [ebp - 0x48c]
            //   e8????????           |                     
            //   8d8590fbffff         | lea                 eax, [ebp - 0x470]

        $sequence_1 = { 85c0 7418 8b858cfbffff 85c0 7407 50 }
            // n = 6, score = 200
            //   85c0                 | test                eax, eax
            //   7418                 | je                  0x1a
            //   8b858cfbffff         | mov                 eax, dword ptr [ebp - 0x474]
            //   85c0                 | test                eax, eax
            //   7407                 | je                  9
            //   50                   | push                eax

        $sequence_2 = { 8b0c8550704100 8a043b 03ce 8b75dc }
            // n = 4, score = 200
            //   8b0c8550704100       | mov                 ecx, dword ptr [eax*4 + 0x417050]
            //   8a043b               | mov                 al, byte ptr [ebx + edi]
            //   03ce                 | add                 ecx, esi
            //   8b75dc               | mov                 esi, dword ptr [ebp - 0x24]

        $sequence_3 = { eb6f 8b07 8d1c85446d4100 8b33 85f6 }
            // n = 5, score = 200
            //   eb6f                 | jmp                 0x71
            //   8b07                 | mov                 eax, dword ptr [edi]
            //   8d1c85446d4100       | lea                 ebx, [eax*4 + 0x416d44]
            //   8b33                 | mov                 esi, dword ptr [ebx]
            //   85f6                 | test                esi, esi

        $sequence_4 = { e8???????? be01000000 8b95d8fbffff 83fa08 7235 }
            // n = 5, score = 200
            //   e8????????           |                     
            //   be01000000           | mov                 esi, 1
            //   8b95d8fbffff         | mov                 edx, dword ptr [ebp - 0x428]
            //   83fa08               | cmp                 edx, 8
            //   7235                 | jb                  0x37

        $sequence_5 = { c7404860604100 8b4508 6689486c 8b4508 66898872010000 8d4dff 8b4508 }
            // n = 7, score = 200
            //   c7404860604100       | mov                 dword ptr [eax + 0x48], 0x416060
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   6689486c             | mov                 word ptr [eax + 0x6c], cx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   66898872010000       | mov                 word ptr [eax + 0x172], cx
            //   8d4dff               | lea                 ecx, [ebp - 1]
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]

        $sequence_6 = { c7404860604100 8b4508 6689486c 8b4508 66898872010000 }
            // n = 5, score = 200
            //   c7404860604100       | mov                 dword ptr [eax + 0x48], 0x416060
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   6689486c             | mov                 word ptr [eax + 0x6c], cx
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   66898872010000       | mov                 word ptr [eax + 0x172], cx

        $sequence_7 = { 33c0 c744246000000000 c744246407000000 6689442450 }
            // n = 4, score = 200
            //   33c0                 | xor                 eax, eax
            //   c744246000000000     | mov                 dword ptr [esp + 0x60], 0
            //   c744246407000000     | mov                 dword ptr [esp + 0x64], 7
            //   6689442450           | mov                 word ptr [esp + 0x50], ax

        $sequence_8 = { 8d85a8fbffff 6a01 0f4385a8fbffff 68???????? }
            // n = 4, score = 200
            //   8d85a8fbffff         | lea                 eax, [ebp - 0x458]
            //   6a01                 | push                1
            //   0f4385a8fbffff       | cmovae              eax, dword ptr [ebp - 0x458]
            //   68????????           |                     

        $sequence_9 = { c1fa06 8934b8 8bc7 83e03f 6bc838 8b049550704100 8b440818 }
            // n = 7, score = 200
            //   c1fa06               | sar                 edx, 6
            //   8934b8               | mov                 dword ptr [eax + edi*4], esi
            //   8bc7                 | mov                 eax, edi
            //   83e03f               | and                 eax, 0x3f
            //   6bc838               | imul                ecx, eax, 0x38
            //   8b049550704100       | mov                 eax, dword ptr [edx*4 + 0x417050]
            //   8b440818             | mov                 eax, dword ptr [eax + ecx + 0x18]

    condition:
        7 of them and filesize < 245760
}