rule win_tinyloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.tinyloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tinyloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { f7d2 f7d1 5b 89d0 c1c010 6689c8 90 }
            // n = 7, score = 200
            //   f7d2                 | not                 edx
            //   f7d1                 | not                 ecx
            //   5b                   | pop                 ebx
            //   89d0                 | mov                 eax, edx
            //   c1c010               | rol                 eax, 0x10
            //   6689c8               | mov                 ax, cx
            //   90                   | nop                 

        $sequence_1 = { 8b1d???????? 90 8998f8070000 90 }
            // n = 4, score = 200
            //   8b1d????????         |                     
            //   90                   | nop                 
            //   8998f8070000         | mov                 dword ptr [eax + 0x7f8], ebx
            //   90                   | nop                 

        $sequence_2 = { 83ec20 48 8d0db7130000 48 }
            // n = 4, score = 100
            //   83ec20               | sub                 esp, 0x20
            //   48                   | dec                 eax
            //   8d0db7130000         | lea                 ecx, [0x13b7]
            //   48                   | dec                 eax

        $sequence_3 = { 90 29d8 90 31db }
            // n = 4, score = 100
            //   90                   | nop                 
            //   29d8                 | sub                 eax, ebx
            //   90                   | nop                 
            //   31db                 | xor                 ebx, ebx

        $sequence_4 = { 895838 90 48 89c6 90 48 0500400100 }
            // n = 7, score = 100
            //   895838               | mov                 dword ptr [eax + 0x38], ebx
            //   90                   | nop                 
            //   48                   | dec                 eax
            //   89c6                 | mov                 esi, eax
            //   90                   | nop                 
            //   48                   | dec                 eax
            //   0500400100           | add                 eax, 0x14000

        $sequence_5 = { 8b5d00 66894308 6a10 ffb5a8050000 }
            // n = 4, score = 100
            //   8b5d00               | mov                 ebx, dword ptr [ebp]
            //   66894308             | mov                 word ptr [ebx + 8], ax
            //   6a10                 | push                0x10
            //   ffb5a8050000         | push                dword ptr [ebp + 0x5a8]

        $sequence_6 = { 637574 6541 0050ff 15???????? c705????????00010000 68???????? 68???????? }
            // n = 7, score = 100
            //   637574               | arpl                word ptr [ebp + 0x74], si
            //   6541                 | inc                 ecx
            //   0050ff               | add                 byte ptr [eax - 1], dl
            //   15????????           |                     
            //   c705????????00010000     |     
            //   68????????           |                     
            //   68????????           |                     

        $sequence_7 = { 81fb04030000 730d 90 83c004 90 83c304 }
            // n = 6, score = 100
            //   81fb04030000         | cmp                 ebx, 0x304
            //   730d                 | jae                 0xf
            //   90                   | nop                 
            //   83c004               | add                 eax, 4
            //   90                   | nop                 
            //   83c304               | add                 ebx, 4

        $sequence_8 = { 90 0500400100 90 31db 90 90 }
            // n = 6, score = 100
            //   90                   | nop                 
            //   0500400100           | add                 eax, 0x14000
            //   90                   | nop                 
            //   31db                 | xor                 ebx, ebx
            //   90                   | nop                 
            //   90                   | nop                 

        $sequence_9 = { 0500080000 894520 ffb5a0050000 6802020000 ff15???????? }
            // n = 5, score = 100
            //   0500080000           | add                 eax, 0x800
            //   894520               | mov                 dword ptr [ebp + 0x20], eax
            //   ffb5a0050000         | push                dword ptr [ebp + 0x5a0]
            //   6802020000           | push                0x202
            //   ff15????????         |                     

        $sequence_10 = { 8998f8070000 90 48 8b1d???????? 90 }
            // n = 5, score = 100
            //   8998f8070000         | mov                 dword ptr [eax + 0x7f8], ebx
            //   90                   | nop                 
            //   48                   | dec                 eax
            //   8b1d????????         |                     
            //   90                   | nop                 

        $sequence_11 = { 48 8d0dedffffff ff15???????? 48 83c420 }
            // n = 5, score = 100
            //   48                   | dec                 eax
            //   8d0dedffffff         | lea                 ecx, [0xffffffed]
            //   ff15????????         |                     
            //   48                   | dec                 eax
            //   83c420               | add                 esp, 0x20

        $sequence_12 = { c70000000000 c7855808000000000000 8b5d00 039d58080000 6a00 }
            // n = 5, score = 100
            //   c70000000000         | mov                 dword ptr [eax], 0
            //   c7855808000000000000     | mov    dword ptr [ebp + 0x858], 0
            //   8b5d00               | mov                 ebx, dword ptr [ebp]
            //   039d58080000         | add                 ebx, dword ptr [ebp + 0x858]
            //   6a00                 | push                0

        $sequence_13 = { 83ec20 48 c7c100000000 48 8d15e6110000 }
            // n = 5, score = 100
            //   83ec20               | sub                 esp, 0x20
            //   48                   | dec                 eax
            //   c7c100000000         | mov                 ecx, 0
            //   48                   | dec                 eax
            //   8d15e6110000         | lea                 edx, [0x11e6]

        $sequence_14 = { 90 8bbb97114000 90 8938 90 }
            // n = 5, score = 100
            //   90                   | nop                 
            //   8bbb97114000         | mov                 edi, dword ptr [ebx + 0x401197]
            //   90                   | nop                 
            //   8938                 | mov                 dword ptr [eax], edi
            //   90                   | nop                 

        $sequence_15 = { 8b8540050000 8b5d00 894308 8b85f8070000 8b5d00 894304 }
            // n = 6, score = 100
            //   8b8540050000         | mov                 eax, dword ptr [ebp + 0x540]
            //   8b5d00               | mov                 ebx, dword ptr [ebp]
            //   894308               | mov                 dword ptr [ebx + 8], eax
            //   8b85f8070000         | mov                 eax, dword ptr [ebp + 0x7f8]
            //   8b5d00               | mov                 ebx, dword ptr [ebp]
            //   894304               | mov                 dword ptr [ebx + 4], eax

        $sequence_16 = { 3b8558080000 7402 ebb3 31c0 31db 31c9 31d2 }
            // n = 7, score = 100
            //   3b8558080000         | cmp                 eax, dword ptr [ebp + 0x858]
            //   7402                 | je                  4
            //   ebb3                 | jmp                 0xffffffb5
            //   31c0                 | xor                 eax, eax
            //   31db                 | xor                 ebx, ebx
            //   31c9                 | xor                 ecx, ecx
            //   31d2                 | xor                 edx, edx

        $sequence_17 = { 8b1d???????? 90 895830 90 8b1d???????? 90 895838 }
            // n = 7, score = 100
            //   8b1d????????         |                     
            //   90                   | nop                 
            //   895830               | mov                 dword ptr [eax + 0x30], ebx
            //   90                   | nop                 
            //   8b1d????????         |                     
            //   90                   | nop                 
            //   895838               | mov                 dword ptr [eax + 0x38], ebx

        $sequence_18 = { 8b85f8070000 8b5d00 894304 8b5d00 81c300040000 31c0 }
            // n = 6, score = 100
            //   8b85f8070000         | mov                 eax, dword ptr [ebp + 0x7f8]
            //   8b5d00               | mov                 ebx, dword ptr [ebp]
            //   894304               | mov                 dword ptr [ebx + 4], eax
            //   8b5d00               | mov                 ebx, dword ptr [ebp]
            //   81c300040000         | add                 ebx, 0x400
            //   31c0                 | xor                 eax, eax

        $sequence_19 = { 8b4500 83c00c ffd0 31db 8b4500 8b8000040000 }
            // n = 6, score = 100
            //   8b4500               | mov                 eax, dword ptr [ebp]
            //   83c00c               | add                 eax, 0xc
            //   ffd0                 | call                eax
            //   31db                 | xor                 ebx, ebx
            //   8b4500               | mov                 eax, dword ptr [ebp]
            //   8b8000040000         | mov                 eax, dword ptr [eax + 0x400]

        $sequence_20 = { 8d0dea0e0000 ff15???????? 48 83c420 48 8d35d90e0000 48 }
            // n = 7, score = 100
            //   8d0dea0e0000         | lea                 ecx, [0xeea]
            //   ff15????????         |                     
            //   48                   | dec                 eax
            //   83c420               | add                 esp, 0x20
            //   48                   | dec                 eax
            //   8d35d90e0000         | lea                 esi, [0xed9]
            //   48                   | dec                 eax

        $sequence_21 = { 01da 83c20c 310a 3b8558080000 7308 83c004 }
            // n = 6, score = 100
            //   01da                 | add                 edx, ebx
            //   83c20c               | add                 edx, 0xc
            //   310a                 | xor                 dword ptr [edx], ecx
            //   3b8558080000         | cmp                 eax, dword ptr [ebp + 0x858]
            //   7308                 | jae                 0xa
            //   83c004               | add                 eax, 4

    condition:
        7 of them and filesize < 40960
}