rule win_tinyturla_ng_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.tinyturla_ng."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tinyturla_ng"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4881ec90000000 488b05???????? 4833c4 4889451f 488bda 488bf1 }
            // n = 6, score = 200
            //   4881ec90000000       | dec                 eax
            //   488b05????????       |                     
            //   4833c4               | cmovb               ebx, ecx
            //   4889451f             | dec                 eax
            //   488bda               | cmp                 ebx, edi
            //   488bf1               | je                  0x79a

        $sequence_1 = { 488bcf e8???????? 33c9 eb15 }
            // n = 4, score = 200
            //   488bcf               | dec                 eax
            //   e8????????           |                     
            //   33c9                 | lea                 eax, [0x26a6c]
            //   eb15                 | dec                 eax

        $sequence_2 = { 488d7027 4883e6e0 488946f8 eb36 b816000000 483bf8 480f42f8 }
            // n = 7, score = 200
            //   488d7027             | dec                 eax
            //   4883e6e0             | lea                 ecx, [0x220d4]
            //   488946f8             | xorps               xmm0, xmm0
            //   eb36                 | dec                 eax
            //   b816000000           | mov                 dword ptr [esp + 0x20], eax
            //   483bf8               | dec                 eax
            //   480f42f8             | mov                 dword ptr [ebx], ecx

        $sequence_3 = { c60600 8b87b8020000 8987b4020000 8b8fb4020000 ff15???????? 80bfcc02000000 0f8579fdffff }
            // n = 7, score = 200
            //   c60600               | dec                 eax
            //   8b87b8020000         | lea                 eax, [0x1ef2a]
            //   8987b4020000         | dec                 eax
            //   8b8fb4020000         | cmp                 dword ptr [edi - 0x10], eax
            //   ff15????????         |                     
            //   80bfcc02000000       | je                  0x61a
            //   0f8579fdffff         | dec                 eax

        $sequence_4 = { 85c0 0f8572010000 488b4d0f 488d45ff 41b901000000 4889442420 4533c0 }
            // n = 7, score = 200
            //   85c0                 | inc                 edx
            //   0f8572010000         | mov                 ecx, dword ptr [esi + ecx*4 + 0x2c558]
            //   488b4d0f             | dec                 eax
            //   488d45ff             | add                 ecx, esi
            //   41b901000000         | jmp                 ecx
            //   4889442420           | ja                  0x796
            //   4533c0               | inc                 esp

        $sequence_5 = { 4863f0 ff15???????? 488bc8 4c8d4601 33d2 ff15???????? 488bd8 }
            // n = 7, score = 200
            //   4863f0               | test                ecx, ecx
            //   ff15????????         |                     
            //   488bc8               | je                  0x232
            //   4c8d4601             | dec                 eax
            //   33d2                 | mov                 ebx, eax
            //   ff15????????         |                     
            //   488bd8               | dec                 eax

        $sequence_6 = { 8b4558 83e001 85c0 7414 836558fe 488b4d60 }
            // n = 6, score = 200
            //   8b4558               | dec                 eax
            //   83e001               | mov                 dword ptr [ebp + 0x27], eax
            //   85c0                 | xorps               xmm0, xmm0
            //   7414                 | dec                 eax
            //   836558fe             | lea                 esi, [0x44d56]
            //   488b4d60             | mov                 byte ptr [eax + 0x3c], cl

        $sequence_7 = { 488b4d0f 488d45ff 41b901000000 4889442420 4533c0 488d5517 ff15???????? }
            // n = 7, score = 200
            //   488b4d0f             | mov                 dword ptr [esp + 0x38], edi
            //   488d45ff             | dec                 eax
            //   41b901000000         | mov                 ecx, esi
            //   4889442420           | mov                 byte ptr [esi + ebx], 0
            //   4533c0               | dec                 eax
            //   488d5517             | mov                 dword ptr [esp + 0x20], esi
            //   ff15????????         |                     

        $sequence_8 = { 803c0800 75f7 488d5550 48c7c0ffffffff 48ffc0 }
            // n = 5, score = 200
            //   803c0800             | dec                 eax
            //   75f7                 | mov                 eax, dword ptr [ebx + 0x38]
            //   488d5550             | dec                 eax
            //   48c7c0ffffffff       | mov                 ecx, dword ptr [eax]
            //   48ffc0               | jne                 0x2b5

        $sequence_9 = { 4c8d050f92ffff 33d2 33c9 e8???????? }
            // n = 4, score = 200
            //   4c8d050f92ffff       | dec                 ecx
            //   33d2                 | lea                 ecx, [ebp + 8]
            //   33c9                 | dec                 eax
            //   e8????????           |                     

    condition:
        7 of them and filesize < 635904
}