rule win_tofsee_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.tofsee."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tofsee"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6864006400 ff7510 ff15???????? 85c0 7404 }
            // n = 5, score = 400
            //   6864006400           | push                0x640064
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7404                 | je                  6

        $sequence_1 = { 5e c3 55 8bec 83ec14 8365f400 8365f800 }
            // n = 7, score = 400
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   55                   | push                ebp
            //   8bec                 | mov                 ebp, esp
            //   83ec14               | sub                 esp, 0x14
            //   8365f400             | and                 dword ptr [ebp - 0xc], 0
            //   8365f800             | and                 dword ptr [ebp - 8], 0

        $sequence_2 = { 57 8d8580fbffff eb68 03d8 81fbf4010000 0f8f92000000 }
            // n = 6, score = 400
            //   57                   | push                edi
            //   8d8580fbffff         | lea                 eax, [ebp - 0x480]
            //   eb68                 | jmp                 0x6a
            //   03d8                 | add                 ebx, eax
            //   81fbf4010000         | cmp                 ebx, 0x1f4
            //   0f8f92000000         | jg                  0x98

        $sequence_3 = { 85c9 8816 7ff0 017dfc eb13 8b45ec }
            // n = 6, score = 400
            //   85c9                 | test                ecx, ecx
            //   8816                 | mov                 byte ptr [esi], dl
            //   7ff0                 | jg                  0xfffffff2
            //   017dfc               | add                 dword ptr [ebp - 4], edi
            //   eb13                 | jmp                 0x15
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]

        $sequence_4 = { 51 50 53 e8???????? 8b4c241c 8b413c 56 }
            // n = 7, score = 400
            //   51                   | push                ecx
            //   50                   | push                eax
            //   53                   | push                ebx
            //   e8????????           |                     
            //   8b4c241c             | mov                 ecx, dword ptr [esp + 0x1c]
            //   8b413c               | mov                 eax, dword ptr [ecx + 0x3c]
            //   56                   | push                esi

        $sequence_5 = { ff75fc e8???????? 83c40c 56 ff75f8 8d45d4 6a03 }
            // n = 7, score = 400
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   56                   | push                esi
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   8d45d4               | lea                 eax, [ebp - 0x2c]
            //   6a03                 | push                3

        $sequence_6 = { 8b4e10 85c9 7412 33d2 f7f1 894df8 8945fc }
            // n = 7, score = 400
            //   8b4e10               | mov                 ecx, dword ptr [esi + 0x10]
            //   85c9                 | test                ecx, ecx
            //   7412                 | je                  0x14
            //   33d2                 | xor                 edx, edx
            //   f7f1                 | div                 ecx
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_7 = { e9???????? 68???????? ff7514 e8???????? 59 59 83fb05 }
            // n = 7, score = 400
            //   e9????????           |                     
            //   68????????           |                     
            //   ff7514               | push                dword ptr [ebp + 0x14]
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   83fb05               | cmp                 ebx, 5

        $sequence_8 = { 391e 895dbc 8975f4 7e7f 83c608 bf???????? 8b46fc }
            // n = 7, score = 400
            //   391e                 | cmp                 dword ptr [esi], ebx
            //   895dbc               | mov                 dword ptr [ebp - 0x44], ebx
            //   8975f4               | mov                 dword ptr [ebp - 0xc], esi
            //   7e7f                 | jle                 0x81
            //   83c608               | add                 esi, 8
            //   bf????????           |                     
            //   8b46fc               | mov                 eax, dword ptr [esi - 4]

        $sequence_9 = { 0f8498000000 8b4510 8938 8b450c 8d4801 8a10 40 }
            // n = 7, score = 400
            //   0f8498000000         | je                  0x9e
            //   8b4510               | mov                 eax, dword ptr [ebp + 0x10]
            //   8938                 | mov                 dword ptr [eax], edi
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   8d4801               | lea                 ecx, [eax + 1]
            //   8a10                 | mov                 dl, byte ptr [eax]
            //   40                   | inc                 eax

    condition:
        7 of them and filesize < 147456
}