rule win_tokyox_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.tokyox."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tokyox"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ff15???????? 85c0 0f84b6010000 8d4590 }
            // n = 4, score = 200
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   0f84b6010000         | je                  0x1bc
            //   8d4590               | lea                 eax, [ebp - 0x70]

        $sequence_1 = { e8???????? 8b4508 83c40c b90d0a0000 66890c07 }
            // n = 5, score = 200
            //   e8????????           |                     
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   83c40c               | add                 esp, 0xc
            //   b90d0a0000           | mov                 ecx, 0xa0d
            //   66890c07             | mov                 word ptr [edi + eax], cx

        $sequence_2 = { c745f450726f64 50 6a00 8d45f4 c745f87563744e }
            // n = 5, score = 200
            //   c745f450726f64       | mov                 dword ptr [ebp - 0xc], 0x646f7250
            //   50                   | push                eax
            //   6a00                 | push                0
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   c745f87563744e       | mov                 dword ptr [ebp - 8], 0x4e746375

        $sequence_3 = { 0f842e020000 8d4df0 c745fc00000000 51 }
            // n = 4, score = 200
            //   0f842e020000         | je                  0x234
            //   8d4df0               | lea                 ecx, [ebp - 0x10]
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   51                   | push                ecx

        $sequence_4 = { 8d45f8 50 6a05 ff7608 ffd7 6a3c ff7510 }
            // n = 7, score = 200
            //   8d45f8               | lea                 eax, [ebp - 8]
            //   50                   | push                eax
            //   6a05                 | push                5
            //   ff7608               | push                dword ptr [esi + 8]
            //   ffd7                 | call                edi
            //   6a3c                 | push                0x3c
            //   ff7510               | push                dword ptr [ebp + 0x10]

        $sequence_5 = { 51 56 6a00 68e9fd0000 ff15???????? 8945e4 33db }
            // n = 7, score = 200
            //   51                   | push                ecx
            //   56                   | push                esi
            //   6a00                 | push                0
            //   68e9fd0000           | push                0xfde9
            //   ff15????????         |                     
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   33db                 | xor                 ebx, ebx

        $sequence_6 = { 7534 83f801 721f 66a1???????? 8d5601 }
            // n = 5, score = 200
            //   7534                 | jne                 0x36
            //   83f801               | cmp                 eax, 1
            //   721f                 | jb                  0x21
            //   66a1????????         |                     
            //   8d5601               | lea                 edx, [esi + 1]

        $sequence_7 = { 8bec a1???????? 3b05???????? 0f85a10f0000 ff7508 e8???????? 59 }
            // n = 7, score = 200
            //   8bec                 | mov                 ebp, esp
            //   a1????????           |                     
            //   3b05????????         |                     
            //   0f85a10f0000         | jne                 0xfa7
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   59                   | pop                 ecx

        $sequence_8 = { 8bf2 c745a046003400 c745a435003000 c745a831002d00 c745ac46003400 c745b034004700 c745b42d003400 }
            // n = 7, score = 200
            //   8bf2                 | mov                 esi, edx
            //   c745a046003400       | mov                 dword ptr [ebp - 0x60], 0x340046
            //   c745a435003000       | mov                 dword ptr [ebp - 0x5c], 0x300035
            //   c745a831002d00       | mov                 dword ptr [ebp - 0x58], 0x2d0031
            //   c745ac46003400       | mov                 dword ptr [ebp - 0x54], 0x340046
            //   c745b034004700       | mov                 dword ptr [ebp - 0x50], 0x470034
            //   c745b42d003400       | mov                 dword ptr [ebp - 0x4c], 0x34002d

        $sequence_9 = { ff15???????? 894608 85c0 754e ff15???????? 8b4e08 }
            // n = 6, score = 200
            //   ff15????????         |                     
            //   894608               | mov                 dword ptr [esi + 8], eax
            //   85c0                 | test                eax, eax
            //   754e                 | jne                 0x50
            //   ff15????????         |                     
            //   8b4e08               | mov                 ecx, dword ptr [esi + 8]

    condition:
        7 of them and filesize < 237568
}