rule win_tonedeaf_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.tonedeaf."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tonedeaf"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b45ec 85c0 740b 6a08 50 }
            // n = 5, score = 400
            //   8b45ec               | mov                 eax, dword ptr [ebp - 0x14]
            //   85c0                 | test                eax, eax
            //   740b                 | je                  0xd
            //   6a08                 | push                8
            //   50                   | push                eax

        $sequence_1 = { 2bd9 2bf1 8bc3 46 }
            // n = 4, score = 400
            //   2bd9                 | sub                 ebx, ecx
            //   2bf1                 | sub                 esi, ecx
            //   8bc3                 | mov                 eax, ebx
            //   46                   | inc                 esi

        $sequence_2 = { 33c0 660fd645d4 33db 8945d8 }
            // n = 4, score = 400
            //   33c0                 | xor                 eax, eax
            //   660fd645d4           | movq                qword ptr [ebp - 0x2c], xmm0
            //   33db                 | xor                 ebx, ebx
            //   8945d8               | mov                 dword ptr [ebp - 0x28], eax

        $sequence_3 = { 8b5004 8d4af8 898c153cffffff 8d45a8 c745fc01000000 }
            // n = 5, score = 400
            //   8b5004               | mov                 edx, dword ptr [eax + 4]
            //   8d4af8               | lea                 ecx, [edx - 8]
            //   898c153cffffff       | mov                 dword ptr [ebp + edx - 0xc4], ecx
            //   8d45a8               | lea                 eax, [ebp - 0x58]
            //   c745fc01000000       | mov                 dword ptr [ebp - 4], 1

        $sequence_4 = { 6a00 ff15???????? 56 ff15???????? 56 ff15???????? }
            // n = 6, score = 400
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   56                   | push                esi
            //   ff15????????         |                     
            //   56                   | push                esi
            //   ff15????????         |                     

        $sequence_5 = { 75f3 8bf3 8a03 43 84c0 }
            // n = 5, score = 400
            //   75f3                 | jne                 0xfffffff5
            //   8bf3                 | mov                 esi, ebx
            //   8a03                 | mov                 al, byte ptr [ebx]
            //   43                   | inc                 ebx
            //   84c0                 | test                al, al

        $sequence_6 = { 33c0 660fd645d4 33db 8945d8 895dd4 }
            // n = 5, score = 400
            //   33c0                 | xor                 eax, eax
            //   660fd645d4           | movq                qword ptr [ebp - 0x2c], xmm0
            //   33db                 | xor                 ebx, ebx
            //   8945d8               | mov                 dword ptr [ebp - 0x28], eax
            //   895dd4               | mov                 dword ptr [ebp - 0x2c], ebx

        $sequence_7 = { 75f3 8bf3 8a03 43 84c0 75f9 2bde }
            // n = 7, score = 400
            //   75f3                 | jne                 0xfffffff5
            //   8bf3                 | mov                 esi, ebx
            //   8a03                 | mov                 al, byte ptr [ebx]
            //   43                   | inc                 ebx
            //   84c0                 | test                al, al
            //   75f9                 | jne                 0xfffffffb
            //   2bde                 | sub                 ebx, esi

        $sequence_8 = { c745dc00000000 33c0 660fd645d4 33db 8945d8 895dd4 }
            // n = 6, score = 400
            //   c745dc00000000       | mov                 dword ptr [ebp - 0x24], 0
            //   33c0                 | xor                 eax, eax
            //   660fd645d4           | movq                qword ptr [ebp - 0x2c], xmm0
            //   33db                 | xor                 ebx, ebx
            //   8945d8               | mov                 dword ptr [ebp - 0x28], eax
            //   895dd4               | mov                 dword ptr [ebp - 0x2c], ebx

        $sequence_9 = { 8a0e 8d7601 884c32ff 84c9 75f3 8bf3 8a03 }
            // n = 7, score = 400
            //   8a0e                 | mov                 cl, byte ptr [esi]
            //   8d7601               | lea                 esi, [esi + 1]
            //   884c32ff             | mov                 byte ptr [edx + esi - 1], cl
            //   84c9                 | test                cl, cl
            //   75f3                 | jne                 0xfffffff5
            //   8bf3                 | mov                 esi, ebx
            //   8a03                 | mov                 al, byte ptr [ebx]

    condition:
        7 of them and filesize < 851968
}