rule win_transbox_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.transbox."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.transbox"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8bf1 8bda 57 837e1408 }
            // n = 4, score = 100
            //   8bf1                 | mov                 esi, ecx
            //   8bda                 | mov                 ebx, edx
            //   57                   | push                edi
            //   837e1408             | cmp                 dword ptr [esi + 0x14], 8

        $sequence_1 = { 33d2 8b5d08 8955fc 8945e4 8945d8 8955e8 395104 }
            // n = 7, score = 100
            //   33d2                 | xor                 edx, edx
            //   8b5d08               | mov                 ebx, dword ptr [ebp + 8]
            //   8955fc               | mov                 dword ptr [ebp - 4], edx
            //   8945e4               | mov                 dword ptr [ebp - 0x1c], eax
            //   8945d8               | mov                 dword ptr [ebp - 0x28], eax
            //   8955e8               | mov                 dword ptr [ebp - 0x18], edx
            //   395104               | cmp                 dword ptr [ecx + 4], edx

        $sequence_2 = { 8d4db8 e8???????? 8b35???????? 3b35???????? }
            // n = 4, score = 100
            //   8d4db8               | lea                 ecx, [ebp - 0x48]
            //   e8????????           |                     
            //   8b35????????         |                     
            //   3b35????????         |                     

        $sequence_3 = { 74e0 6a04 8d85f8fbffff 50 6a49 6a00 ff964c010000 }
            // n = 7, score = 100
            //   74e0                 | je                  0xffffffe2
            //   6a04                 | push                4
            //   8d85f8fbffff         | lea                 eax, [ebp - 0x408]
            //   50                   | push                eax
            //   6a49                 | push                0x49
            //   6a00                 | push                0
            //   ff964c010000         | call                dword ptr [esi + 0x14c]

        $sequence_4 = { f7fb 56 8bf0 bbe0077e00 8bc3 2bc6 83f801 }
            // n = 7, score = 100
            //   f7fb                 | idiv                ebx
            //   56                   | push                esi
            //   8bf0                 | mov                 esi, eax
            //   bbe0077e00           | mov                 ebx, 0x7e07e0
            //   8bc3                 | mov                 eax, ebx
            //   2bc6                 | sub                 eax, esi
            //   83f801               | cmp                 eax, 1

        $sequence_5 = { 57 8bf1 33ff 6804010000 57 8d4610 c706???????? }
            // n = 7, score = 100
            //   57                   | push                edi
            //   8bf1                 | mov                 esi, ecx
            //   33ff                 | xor                 edi, edi
            //   6804010000           | push                0x104
            //   57                   | push                edi
            //   8d4610               | lea                 eax, [esi + 0x10]
            //   c706????????         |                     

        $sequence_6 = { 894608 85c0 74e0 6a04 8d85f8fbffff 50 6a49 }
            // n = 7, score = 100
            //   894608               | mov                 dword ptr [esi + 8], eax
            //   85c0                 | test                eax, eax
            //   74e0                 | je                  0xffffffe2
            //   6a04                 | push                4
            //   8d85f8fbffff         | lea                 eax, [ebp - 0x408]
            //   50                   | push                eax
            //   6a49                 | push                0x49

        $sequence_7 = { 8985d8faffff 8b8544faffff 8985dcfaffff 397e14 7204 8b16 }
            // n = 6, score = 100
            //   8985d8faffff         | mov                 dword ptr [ebp - 0x528], eax
            //   8b8544faffff         | mov                 eax, dword ptr [ebp - 0x5bc]
            //   8985dcfaffff         | mov                 dword ptr [ebp - 0x524], eax
            //   397e14               | cmp                 dword ptr [esi + 0x14], edi
            //   7204                 | jb                  6
            //   8b16                 | mov                 edx, dword ptr [esi]

        $sequence_8 = { e8???????? 83c420 b812000000 33d2 8a900c530110 6683bc96760a000000 7506 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   83c420               | add                 esp, 0x20
            //   b812000000           | mov                 eax, 0x12
            //   33d2                 | xor                 edx, edx
            //   8a900c530110         | mov                 dl, byte ptr [eax + 0x1001530c]
            //   6683bc96760a000000     | cmp    word ptr [esi + edx*4 + 0xa76], 0
            //   7506                 | jne                 8

        $sequence_9 = { 8d8504e1ffff 89bd44e1ffff 50 33db 89b540e1ffff 53 }
            // n = 6, score = 100
            //   8d8504e1ffff         | lea                 eax, [ebp - 0x1efc]
            //   89bd44e1ffff         | mov                 dword ptr [ebp - 0x1ebc], edi
            //   50                   | push                eax
            //   33db                 | xor                 ebx, ebx
            //   89b540e1ffff         | mov                 dword ptr [ebp - 0x1ec0], esi
            //   53                   | push                ebx

    condition:
        7 of them and filesize < 288768
}