rule win_transferloader_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.transferloader."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.transferloader"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0fb609 880c02 e9???????? 48837c244800 7412 4c8b442448 33d2 }
            // n = 7, score = 100
            //   0fb609               | jne                 0x16f9
            //   880c02               | dec                 eax
            //   e9????????           |                     
            //   48837c244800         | arpl                word ptr [esp + 4], ax
            //   7412                 | dec                 eax
            //   4c8b442448           | mov                 dword ptr [esp + 0x18], eax
            //   33d2                 | dec                 eax

        $sequence_1 = { 4889442438 41b810000000 488b542438 488b4c2430 }
            // n = 4, score = 100
            //   4889442438           | mov                 eax, dword ptr [esp + 0xc0]
            //   41b810000000         | dec                 eax
            //   488b542438           | mov                 edx, dword ptr [esp + 0xb8]
            //   488b4c2430           | dec                 eax

        $sequence_2 = { 88440c20 b801000000 486bc002 b901000000 486bc901 }
            // n = 5, score = 100
            //   88440c20             | mov                 eax, dword ptr [eax + 8]
            //   b801000000           | dec                 eax
            //   486bc002             | mov                 dword ptr [esp + 0x40], eax
            //   b901000000           | dec                 eax
            //   486bc901             | mov                 eax, dword ptr [esp + 0xd0]

        $sequence_3 = { 488d442424 48898424f8000000 488d442420 4889842400010000 }
            // n = 4, score = 100
            //   488d442424           | mov                 byte ptr [eax + ecx], dl
            //   48898424f8000000     | dec                 eax
            //   488d442420           | mov                 eax, dword ptr [esp + 0xa0]
            //   4889842400010000     | dec                 eax

        $sequence_4 = { b903000000 f3aa 48b8bce015361abafbff 48898424c8000000 c744242c00000000 486344242c }
            // n = 6, score = 100
            //   b903000000           | cmp                 dword ptr [esp + 0x20], 0
            //   f3aa                 | xor                 eax, eax
            //   48b8bce015361abafbff     | call    eax
            //   48898424c8000000     | dec                 eax
            //   c744242c00000000     | mov                 eax, dword ptr [0x60]
            //   486344242c           | dec                 eax

        $sequence_5 = { 4889842498010000 488b842490010000 4889842468010000 c6442440eb c644244108 c644244248 c644244389 }
            // n = 7, score = 100
            //   4889842498010000     | inc                 eax
            //   488b842490010000     | dec                 eax
            //   4889842468010000     | mov                 eax, dword ptr [esp + 0x30]
            //   c6442440eb           | dec                 eax
            //   c644244108           | mov                 dword ptr [esp + 0x48], eax
            //   c644244248           | dec                 eax
            //   c644244389           | mov                 eax, dword ptr [esp + 0x40]

        $sequence_6 = { 488b09 4863493c 480308 488bc1 4889442430 488b442430 }
            // n = 6, score = 100
            //   488b09               | jae                 0x109e
            //   4863493c             | dec                 eax
            //   480308               | arpl                word ptr [esp + 0x24], ax
            //   488bc1               | jae                 0x10b4
            //   4889442430           | dec                 eax
            //   488b442430           | lea                 eax, [0x105df]

        $sequence_7 = { 4889542410 48894c2408 4881eca8000000 c6442420eb c644242108 }
            // n = 5, score = 100
            //   4889542410           | mov                 byte ptr [esp + 0x2f], 0x66
            //   48894c2408           | mov                 byte ptr [esp + 0x30], 0xdd
            //   4881eca8000000       | mov                 byte ptr [esp + 0x31], 0x5d
            //   c6442420eb           | mov                 byte ptr [esp + 0x2f], 8
            //   c644242108           | mov                 byte ptr [esp + 0x30], 0xe4

        $sequence_8 = { 488b442420 4889442428 488b442428 0fb700 3d4d5a0000 7404 32c0 }
            // n = 7, score = 100
            //   488b442420           | dec                 eax
            //   4889442428           | mov                 ecx, dword ptr [esp]
            //   488b442428           | dec                 eax
            //   0fb700               | mov                 edx, dword ptr [esp + 0x28]
            //   3d4d5a0000           | dec                 eax
            //   7404                 | add                 edx, ecx
            //   32c0                 | dec                 eax

        $sequence_9 = { 488b8c2420010000 ff15???????? 4883bc24e000000000 7418 4c8b8424e0000000 33d2 }
            // n = 6, score = 100
            //   488b8c2420010000     | mov                 ecx, dword ptr [esp + 0x3c]
            //   ff15????????         |                     
            //   4883bc24e000000000     | xor    ecx, eax
            //   7418                 | mov                 eax, ecx
            //   4c8b8424e0000000     | mov                 dword ptr [esp + 0x40], eax
            //   33d2                 | mov                 ecx, dword ptr [esp + 0x20]

    condition:
        7 of them and filesize < 216064
}