rule win_troldesh_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.troldesh."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.troldesh"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { ffd5 85c0 755e 6a08 8d442478 50 8d44244c }
            // n = 7, score = 600
            //   ffd5                 | call                ebp
            //   85c0                 | test                eax, eax
            //   755e                 | jne                 0x60
            //   6a08                 | push                8
            //   8d442478             | lea                 eax, [esp + 0x78]
            //   50                   | push                eax
            //   8d44244c             | lea                 eax, [esp + 0x4c]

        $sequence_1 = { e8???????? 56 57 8bf3 b8ff0f0000 c1ee0c 8bfb }
            // n = 7, score = 600
            //   e8????????           |                     
            //   56                   | push                esi
            //   57                   | push                edi
            //   8bf3                 | mov                 esi, ebx
            //   b8ff0f0000           | mov                 eax, 0xfff
            //   c1ee0c               | shr                 esi, 0xc
            //   8bfb                 | mov                 edi, ebx

        $sequence_2 = { ff75fc 50 e8???????? 83c40c 85c0 741a 8b4610 }
            // n = 7, score = 600
            //   ff75fc               | push                dword ptr [ebp - 4]
            //   50                   | push                eax
            //   e8????????           |                     
            //   83c40c               | add                 esp, 0xc
            //   85c0                 | test                eax, eax
            //   741a                 | je                  0x1c
            //   8b4610               | mov                 eax, dword ptr [esi + 0x10]

        $sequence_3 = { e8???????? 8b3e 53 e8???????? c7839400000001000000 8b36 8b462c }
            // n = 7, score = 600
            //   e8????????           |                     
            //   8b3e                 | mov                 edi, dword ptr [esi]
            //   53                   | push                ebx
            //   e8????????           |                     
            //   c7839400000001000000     | mov    dword ptr [ebx + 0x94], 1
            //   8b36                 | mov                 esi, dword ptr [esi]
            //   8b462c               | mov                 eax, dword ptr [esi + 0x2c]

        $sequence_4 = { e8???????? e9???????? 83f807 0f85d4000000 8bf5 e8???????? 8bf0 }
            // n = 7, score = 600
            //   e8????????           |                     
            //   e9????????           |                     
            //   83f807               | cmp                 eax, 7
            //   0f85d4000000         | jne                 0xda
            //   8bf5                 | mov                 esi, ebp
            //   e8????????           |                     
            //   8bf0                 | mov                 esi, eax

        $sequence_5 = { e8???????? 8b4f04 51 89442418 895c241c e8???????? 83c404 }
            // n = 7, score = 600
            //   e8????????           |                     
            //   8b4f04               | mov                 ecx, dword ptr [edi + 4]
            //   51                   | push                ecx
            //   89442418             | mov                 dword ptr [esp + 0x18], eax
            //   895c241c             | mov                 dword ptr [esp + 0x1c], ebx
            //   e8????????           |                     
            //   83c404               | add                 esp, 4

        $sequence_6 = { e8???????? ff750c ff7508 e8???????? 83c418 eb6d e8???????? }
            // n = 7, score = 600
            //   e8????????           |                     
            //   ff750c               | push                dword ptr [ebp + 0xc]
            //   ff7508               | push                dword ptr [ebp + 8]
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   eb6d                 | jmp                 0x6f
            //   e8????????           |                     

        $sequence_7 = { e8???????? 8b8c249c000000 83c40c 50 57 68???????? 53 }
            // n = 7, score = 600
            //   e8????????           |                     
            //   8b8c249c000000       | mov                 ecx, dword ptr [esp + 0x9c]
            //   83c40c               | add                 esp, 0xc
            //   50                   | push                eax
            //   57                   | push                edi
            //   68????????           |                     
            //   53                   | push                ebx

        $sequence_8 = { ff75f8 8b7070 e8???????? 8945f8 59 85c0 0f8562ffffff }
            // n = 7, score = 600
            //   ff75f8               | push                dword ptr [ebp - 8]
            //   8b7070               | mov                 esi, dword ptr [eax + 0x70]
            //   e8????????           |                     
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   0f8562ffffff         | jne                 0xffffff68

        $sequence_9 = { e9???????? 3975f4 740b 53 e8???????? 59 85c0 }
            // n = 7, score = 600
            //   e9????????           |                     
            //   3975f4               | cmp                 dword ptr [ebp - 0xc], esi
            //   740b                 | je                  0xd
            //   53                   | push                ebx
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax

    condition:
        7 of them and filesize < 3915776
}