rule win_tropidoor_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.tropidoor."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.tropidoor"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 488b8d88010000 488b01 ff5010 488b8d80010000 e9???????? 6644897508 897510 }
            // n = 7, score = 100
            //   488b8d88010000       | inc                 dx
            //   488b01               | cmp                 dword ptr [eax + eax*2], 0
            //   ff5010               | jne                 0x23b
            //   488b8d80010000       | dec                 eax
            //   e9????????           |                     
            //   6644897508           | lea                 edx, [ebp + 0x3b0]
            //   897510               | dec                 ecx

        $sequence_1 = { ff15???????? 0fb74c2420 b8b2070000 663bc8 731a ba01000000 }
            // n = 6, score = 100
            //   ff15????????         |                     
            //   0fb74c2420           | inc                 ecx
            //   b8b2070000           | movzx               eax, word ptr [eax + edx]
            //   663bc8               | test                ax, ax
            //   731a                 | je                  0x17eb
            //   ba01000000           | mov                 word ptr [edx], ax

        $sequence_2 = { 488d9520020000 498bcf e8???????? 4d8b8598000000 4d85c0 0f84a2000000 ba04010000 }
            // n = 7, score = 100
            //   488d9520020000       | mov                 eax, ecx
            //   498bcf               | mov                 word ptr [ebp - 0x2f], ax
            //   e8????????           |                     
            //   4d8b8598000000       | mov                 eax, ecx
            //   4d85c0               | mov                 word ptr [ebp - 0x2f], ax
            //   0f84a2000000         | mov                 eax, ecx
            //   ba04010000           | mov                 word ptr [ebp - 0x2d], ax

        $sequence_3 = { ffd0 85c0 7564 8b459c 83c0fe 413bc5 7725 }
            // n = 7, score = 100
            //   ffd0                 | movzx               edx, ax
            //   85c0                 | shl                 dx, cl
            //   7564                 | mov                 ecx, dword ptr [ebx + 0x28]
            //   8b459c               | inc                 cx
            //   83c0fe               | or                  edx, ebx
            //   413bc5               | mov                 word ptr [ebx + 0x170c], dx
            //   7725                 | mov                 byte ptr [ecx + eax], dl

        $sequence_4 = { 488bcb ff15???????? 418bc4 4883c470 415e 415c 5f }
            // n = 7, score = 100
            //   488bcb               | je                  0xf29
            //   ff15????????         |                     
            //   418bc4               | dec                 esp
            //   4883c470             | mov                 dword ptr [esp + 0x50], esp
            //   415e                 | cmp                 dword ptr [esp + 0x58], 0
            //   415c                 | dec                 esp
            //   5f                   | mov                 dword ptr [esp + 0x60], esi

        $sequence_5 = { ff15???????? e9???????? 8b542478 4c8d8510050000 c744243002000000 488d8db0000000 897c2428 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   e9????????           |                     
            //   8b542478             | push                ebx
            //   4c8d8510050000       | dec                 eax
            //   c744243002000000     | sub                 esp, 0x20
            //   488d8db0000000       | dec                 eax
            //   897c2428             | mov                 ebx, ecx

        $sequence_6 = { 33d2 41b801010000 e8???????? 418bc6 4d8d4c2410 4c8d1d75920300 41be04000000 }
            // n = 7, score = 100
            //   33d2                 | dec                 eax
            //   41b801010000         | lea                 edx, [0xa33d2]
            //   e8????????           |                     
            //   418bc6               | dec                 eax
            //   4d8d4c2410           | lea                 eax, [esp + 0x78]
            //   4c8d1d75920300       | inc                 ebp
            //   41be04000000         | xor                 eax, eax

        $sequence_7 = { 83ff01 0f85d2000000 84c0 740a 458b949b3cb90a00 eb08 458b949b04b90a00 }
            // n = 7, score = 100
            //   83ff01               | inc                 ecx
            //   0f85d2000000         | mov                 eax, 2
            //   84c0                 | dec                 eax
            //   740a                 | lea                 edx, [0x8ee02]
            //   458b949b3cb90a00     | dec                 eax
            //   eb08                 | mov                 ecx, esi
            //   458b949b04b90a00     | dec                 esp

        $sequence_8 = { 8b8c8220060200 4803ca ffe1 488b4c2430 418bc4 488b0cc1 48894c2458 }
            // n = 7, score = 100
            //   8b8c8220060200       | lea                 edx, [0xaf4b7]
            //   4803ca               | dec                 eax
            //   ffe1                 | lea                 ecx, [ebp + 0x260]
            //   488b4c2430           | nop                 
            //   418bc4               | nop                 
            //   488b0cc1             | dec                 eax
            //   48894c2458           | lea                 ebx, [0x4354a]

        $sequence_9 = { 4c8d4d40 4c8d052b630900 488d4db0 e8???????? 48897de0 488d45d0 4983fd10 }
            // n = 7, score = 100
            //   4c8d4d40             | dec                 eax
            //   4c8d052b630900       | lea                 eax, [ebp + 0x1a0]
            //   488d4db0             | jns                 0x7de
            //   e8????????           |                     
            //   48897de0             | inc                 esp
            //   488d45d0             | mov                 eax, eax
            //   4983fd10             | dec                 eax

    condition:
        7 of them and filesize < 1826816
}