rule win_turian_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.turian."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.turian"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 5b 81c420040000 c3 8d442410 6a10 50 }
            // n = 6, score = 400
            //   5b                   | pop                 ebx
            //   81c420040000         | add                 esp, 0x420
            //   c3                   | ret                 
            //   8d442410             | lea                 eax, [esp + 0x10]
            //   6a10                 | push                0x10
            //   50                   | push                eax

        $sequence_1 = { 33db 3bc3 7519 668b44240c 881d???????? 891d???????? }
            // n = 6, score = 400
            //   33db                 | xor                 ebx, ebx
            //   3bc3                 | cmp                 eax, ebx
            //   7519                 | jne                 0x1b
            //   668b44240c           | mov                 ax, word ptr [esp + 0xc]
            //   881d????????         |                     
            //   891d????????         |                     

        $sequence_2 = { 5e c3 8bc8 57 c1e105 }
            // n = 5, score = 400
            //   5e                   | pop                 esi
            //   c3                   | ret                 
            //   8bc8                 | mov                 ecx, eax
            //   57                   | push                edi
            //   c1e105               | shl                 ecx, 5

        $sequence_3 = { 85c0 0f840affffff 5f 5e 5d 33c0 }
            // n = 6, score = 400
            //   85c0                 | test                eax, eax
            //   0f840affffff         | je                  0xffffff10
            //   5f                   | pop                 edi
            //   5e                   | pop                 esi
            //   5d                   | pop                 ebp
            //   33c0                 | xor                 eax, eax

        $sequence_4 = { 83c9ff 33c0 668b15???????? f2ae }
            // n = 4, score = 400
            //   83c9ff               | or                  ecx, 0xffffffff
            //   33c0                 | xor                 eax, eax
            //   668b15????????       |                     
            //   f2ae                 | repne scasb         al, byte ptr es:[edi]

        $sequence_5 = { 8d4c2410 51 e8???????? 8bbc24a0000000 83c404 a1???????? }
            // n = 6, score = 400
            //   8d4c2410             | lea                 ecx, [esp + 0x10]
            //   51                   | push                ecx
            //   e8????????           |                     
            //   8bbc24a0000000       | mov                 edi, dword ptr [esp + 0xa0]
            //   83c404               | add                 esp, 4
            //   a1????????           |                     

        $sequence_6 = { 51 52 ffd5 85c0 7423 a1???????? 43 }
            // n = 7, score = 400
            //   51                   | push                ecx
            //   52                   | push                edx
            //   ffd5                 | call                ebp
            //   85c0                 | test                eax, eax
            //   7423                 | je                  0x25
            //   a1????????           |                     
            //   43                   | inc                 ebx

        $sequence_7 = { 83f810 7e6a 6a00 57 53 }
            // n = 5, score = 400
            //   83f810               | cmp                 eax, 0x10
            //   7e6a                 | jle                 0x6c
            //   6a00                 | push                0
            //   57                   | push                edi
            //   53                   | push                ebx

        $sequence_8 = { 56 57 730c 5f }
            // n = 4, score = 400
            //   56                   | push                esi
            //   57                   | push                edi
            //   730c                 | jae                 0xe
            //   5f                   | pop                 edi

        $sequence_9 = { 8b442414 50 ffd7 56 ff15???????? 83c404 33c0 }
            // n = 7, score = 400
            //   8b442414             | mov                 eax, dword ptr [esp + 0x14]
            //   50                   | push                eax
            //   ffd7                 | call                edi
            //   56                   | push                esi
            //   ff15????????         |                     
            //   83c404               | add                 esp, 4
            //   33c0                 | xor                 eax, eax

    condition:
        7 of them and filesize < 645120
}