rule win_turnedup_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.turnedup."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.turnedup"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a0d c741140f000000 c7411000000000 68???????? 8945a8 c60100 }
            // n = 6, score = 400
            //   6a0d                 | push                0xd
            //   c741140f000000       | mov                 dword ptr [ecx + 0x14], 0xf
            //   c7411000000000       | mov                 dword ptr [ecx + 0x10], 0
            //   68????????           |                     
            //   8945a8               | mov                 dword ptr [ebp - 0x58], eax
            //   c60100               | mov                 byte ptr [ecx], 0

        $sequence_1 = { 85db 7417 8d4df4 8bf3 }
            // n = 4, score = 400
            //   85db                 | test                ebx, ebx
            //   7417                 | je                  0x19
            //   8d4df4               | lea                 ecx, [ebp - 0xc]
            //   8bf3                 | mov                 esi, ebx

        $sequence_2 = { 7f0d 0fbed0 0fbec1 8d4a05 }
            // n = 4, score = 400
            //   7f0d                 | jg                  0xf
            //   0fbed0               | movsx               edx, al
            //   0fbec1               | movsx               eax, cl
            //   8d4a05               | lea                 ecx, [edx + 5]

        $sequence_3 = { c70600000000 c6460401 807e0530 0f8cf1000000 807e0400 7538 8b0e }
            // n = 7, score = 400
            //   c70600000000         | mov                 dword ptr [esi], 0
            //   c6460401             | mov                 byte ptr [esi + 4], 1
            //   807e0530             | cmp                 byte ptr [esi + 5], 0x30
            //   0f8cf1000000         | jl                  0xf7
            //   807e0400             | cmp                 byte ptr [esi + 4], 0
            //   7538                 | jne                 0x3a
            //   8b0e                 | mov                 ecx, dword ptr [esi]

        $sequence_4 = { 740f e8???????? 8b4dbc 8801 }
            // n = 4, score = 400
            //   740f                 | je                  0x11
            //   e8????????           |                     
            //   8b4dbc               | mov                 ecx, dword ptr [ebp - 0x44]
            //   8801                 | mov                 byte ptr [ecx], al

        $sequence_5 = { 8d44244c 50 e8???????? dd542448 8b442434 }
            // n = 5, score = 400
            //   8d44244c             | lea                 eax, [esp + 0x4c]
            //   50                   | push                eax
            //   e8????????           |                     
            //   dd542448             | fst                 qword ptr [esp + 0x48]
            //   8b442434             | mov                 eax, dword ptr [esp + 0x34]

        $sequence_6 = { 7405 884305 eb06 c70300000000 c6430401 8a4b05 884dbb }
            // n = 7, score = 400
            //   7405                 | je                  7
            //   884305               | mov                 byte ptr [ebx + 5], al
            //   eb06                 | jmp                 8
            //   c70300000000         | mov                 dword ptr [ebx], 0
            //   c6430401             | mov                 byte ptr [ebx + 4], 1
            //   8a4b05               | mov                 cl, byte ptr [ebx + 5]
            //   884dbb               | mov                 byte ptr [ebp - 0x45], cl

        $sequence_7 = { ffd3 83ec1c 8bcc 6a0d c741140f000000 c7411000000000 68???????? }
            // n = 7, score = 400
            //   ffd3                 | call                ebx
            //   83ec1c               | sub                 esp, 0x1c
            //   8bcc                 | mov                 ecx, esp
            //   6a0d                 | push                0xd
            //   c741140f000000       | mov                 dword ptr [ecx + 0x14], 0xf
            //   c7411000000000       | mov                 dword ptr [ecx + 0x10], 0
            //   68????????           |                     

        $sequence_8 = { c60100 e8???????? c3 56 }
            // n = 4, score = 400
            //   c60100               | mov                 byte ptr [ecx], 0
            //   e8????????           |                     
            //   c3                   | ret                 
            //   56                   | push                esi

        $sequence_9 = { 8945fc 8d45fc 50 8d4df0 e8???????? 68???????? }
            // n = 6, score = 400
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   8d45fc               | lea                 eax, [ebp - 4]
            //   50                   | push                eax
            //   8d4df0               | lea                 ecx, [ebp - 0x10]
            //   e8????????           |                     
            //   68????????           |                     

    condition:
        7 of them and filesize < 892928
}