rule win_unidentified_001_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_001."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_001"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 741c 83e80a 0f84c6fcffff 2def000000 }
            // n = 4, score = 100
            //   741c                 | je                  0x1e
            //   83e80a               | sub                 eax, 0xa
            //   0f84c6fcffff         | je                  0xfffffccc
            //   2def000000           | sub                 eax, 0xef

        $sequence_1 = { 6830750000 ffd6 8b4df8 85c9 7483 8d45fc }
            // n = 6, score = 100
            //   6830750000           | push                0x7530
            //   ffd6                 | call                esi
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   85c9                 | test                ecx, ecx
            //   7483                 | je                  0xffffff85
            //   8d45fc               | lea                 eax, [ebp - 4]

        $sequence_2 = { 85c9 0f84dafdffff e8???????? 85c0 0f85f3000000 }
            // n = 5, score = 100
            //   85c9                 | test                ecx, ecx
            //   0f84dafdffff         | je                  0xfffffde0
            //   e8????????           |                     
            //   85c0                 | test                eax, eax
            //   0f85f3000000         | jne                 0xf9

        $sequence_3 = { 8b06 8d4dfc 51 56 ff5028 85c0 7d0c }
            // n = 7, score = 100
            //   8b06                 | mov                 eax, dword ptr [esi]
            //   8d4dfc               | lea                 ecx, [ebp - 4]
            //   51                   | push                ecx
            //   56                   | push                esi
            //   ff5028               | call                dword ptr [eax + 0x28]
            //   85c0                 | test                eax, eax
            //   7d0c                 | jge                 0xe

        $sequence_4 = { 895824 895808 c7401c06000000 47 }
            // n = 4, score = 100
            //   895824               | mov                 dword ptr [eax + 0x24], ebx
            //   895808               | mov                 dword ptr [eax + 8], ebx
            //   c7401c06000000       | mov                 dword ptr [eax + 0x1c], 6
            //   47                   | inc                 edi

        $sequence_5 = { 2d0a020000 0f84a2faffff 2d02020000 e9???????? c705????????0d000000 }
            // n = 5, score = 100
            //   2d0a020000           | sub                 eax, 0x20a
            //   0f84a2faffff         | je                  0xfffffaa8
            //   2d02020000           | sub                 eax, 0x202
            //   e9????????           |                     
            //   c705????????0d000000     |     

        $sequence_6 = { 8b4508 83e103 f3a4 8bd0 668b08 }
            // n = 5, score = 100
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   83e103               | and                 ecx, 3
            //   f3a4                 | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   8bd0                 | mov                 edx, eax
            //   668b08               | mov                 cx, word ptr [eax]

        $sequence_7 = { 0f8468feffff 3d4b475a00 0f845dfeffff 3d4d4f5a00 0f8507f9ffff 8325????????00 e9???????? }
            // n = 7, score = 100
            //   0f8468feffff         | je                  0xfffffe6e
            //   3d4b475a00           | cmp                 eax, 0x5a474b
            //   0f845dfeffff         | je                  0xfffffe63
            //   3d4d4f5a00           | cmp                 eax, 0x5a4f4d
            //   0f8507f9ffff         | jne                 0xfffff90d
            //   8325????????00       |                     
            //   e9????????           |                     

        $sequence_8 = { 2df9070000 0f8437010000 2d01010000 0f84e2050000 2df3010000 7420 }
            // n = 6, score = 100
            //   2df9070000           | sub                 eax, 0x7f9
            //   0f8437010000         | je                  0x13d
            //   2d01010000           | sub                 eax, 0x101
            //   0f84e2050000         | je                  0x5e8
            //   2df3010000           | sub                 eax, 0x1f3
            //   7420                 | je                  0x22

        $sequence_9 = { 3d54484100 7416 3d414c4100 753b c705????????09000000 e9???????? }
            // n = 6, score = 100
            //   3d54484100           | cmp                 eax, 0x414854
            //   7416                 | je                  0x18
            //   3d414c4100           | cmp                 eax, 0x414c41
            //   753b                 | jne                 0x3d
            //   c705????????09000000     |     
            //   e9????????           |                     

    condition:
        7 of them and filesize < 65536
}