rule win_unidentified_003_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_003."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_003"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { b8???????? 2b05???????? ff7006 50 50 8d442464 50 }
            // n = 7, score = 100
            //   b8????????           |                     
            //   2b05????????         |                     
            //   ff7006               | push                dword ptr [eax + 6]
            //   50                   | push                eax
            //   50                   | push                eax
            //   8d442464             | lea                 eax, [esp + 0x64]
            //   50                   | push                eax

        $sequence_1 = { 7561 6a00 68???????? 8d45f0 e8???????? }
            // n = 5, score = 100
            //   7561                 | jne                 0x63
            //   6a00                 | push                0
            //   68????????           |                     
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   e8????????           |                     

        $sequence_2 = { 0f8312020000 8dbdf1fdffff 2bf9 8a11 88140f 41 84d2 }
            // n = 7, score = 100
            //   0f8312020000         | jae                 0x218
            //   8dbdf1fdffff         | lea                 edi, [ebp - 0x20f]
            //   2bf9                 | sub                 edi, ecx
            //   8a11                 | mov                 dl, byte ptr [ecx]
            //   88140f               | mov                 byte ptr [edi + ecx], dl
            //   41                   | inc                 ecx
            //   84d2                 | test                dl, dl

        $sequence_3 = { 85c0 75b5 8d45f4 50 8d85e3fbffff 50 }
            // n = 6, score = 100
            //   85c0                 | test                eax, eax
            //   75b5                 | jne                 0xffffffb7
            //   8d45f4               | lea                 eax, [ebp - 0xc]
            //   50                   | push                eax
            //   8d85e3fbffff         | lea                 eax, [ebp - 0x41d]
            //   50                   | push                eax

        $sequence_4 = { 395de0 0f8421010000 8b45e0 8b08 50 }
            // n = 5, score = 100
            //   395de0               | cmp                 dword ptr [ebp - 0x20], ebx
            //   0f8421010000         | je                  0x127
            //   8b45e0               | mov                 eax, dword ptr [ebp - 0x20]
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   50                   | push                eax

        $sequence_5 = { bb01000080 53 ff15???????? 6a22 58 668985f0fbffff 33c0 }
            // n = 7, score = 100
            //   bb01000080           | mov                 ebx, 0x80000001
            //   53                   | push                ebx
            //   ff15????????         |                     
            //   6a22                 | push                0x22
            //   58                   | pop                 eax
            //   668985f0fbffff       | mov                 word ptr [ebp - 0x410], ax
            //   33c0                 | xor                 eax, eax

        $sequence_6 = { 3bc3 7468 3d00100400 741c 3d10100400 7415 3d00100600 }
            // n = 7, score = 100
            //   3bc3                 | cmp                 eax, ebx
            //   7468                 | je                  0x6a
            //   3d00100400           | cmp                 eax, 0x41000
            //   741c                 | je                  0x1e
            //   3d10100400           | cmp                 eax, 0x41010
            //   7415                 | je                  0x17
            //   3d00100600           | cmp                 eax, 0x61000

        $sequence_7 = { ff45fc 8b45fc 8145f80c020000 81c718040000 3b45f0 0f8238ffffff eb07 }
            // n = 7, score = 100
            //   ff45fc               | inc                 dword ptr [ebp - 4]
            //   8b45fc               | mov                 eax, dword ptr [ebp - 4]
            //   8145f80c020000       | add                 dword ptr [ebp - 8], 0x20c
            //   81c718040000         | add                 edi, 0x418
            //   3b45f0               | cmp                 eax, dword ptr [ebp - 0x10]
            //   0f8238ffffff         | jb                  0xffffff3e
            //   eb07                 | jmp                 9

        $sequence_8 = { 8b45a4 3bc3 7464 8945d8 33c0 8d7dac ab }
            // n = 7, score = 100
            //   8b45a4               | mov                 eax, dword ptr [ebp - 0x5c]
            //   3bc3                 | cmp                 eax, ebx
            //   7464                 | je                  0x66
            //   8945d8               | mov                 dword ptr [ebp - 0x28], eax
            //   33c0                 | xor                 eax, eax
            //   8d7dac               | lea                 edi, [ebp - 0x54]
            //   ab                   | stosd               dword ptr es:[edi], eax

        $sequence_9 = { 56 e8???????? 59 59 85c0 7408 c60000 }
            // n = 7, score = 100
            //   56                   | push                esi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   85c0                 | test                eax, eax
            //   7408                 | je                  0xa
            //   c60000               | mov                 byte ptr [eax], 0

    condition:
        7 of them and filesize < 57344
}