rule win_unidentified_006_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_006."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_006"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 817c0afc54494b46 750c 83c2fc e8???????? }
            // n = 4, score = 100
            //   817c0afc54494b46     | cmp                 dword ptr [edx + ecx - 4], 0x464b4954
            //   750c                 | jne                 0xe
            //   83c2fc               | add                 edx, -4
            //   e8????????           |                     

        $sequence_1 = { 83c603 25ff000000 30041a 42 3bd1 72df }
            // n = 6, score = 100
            //   83c603               | add                 esi, 3
            //   25ff000000           | and                 eax, 0xff
            //   30041a               | xor                 byte ptr [edx + ebx], al
            //   42                   | inc                 edx
            //   3bd1                 | cmp                 edx, ecx
            //   72df                 | jb                  0xffffffe1

        $sequence_2 = { 7410 8b55f4 85d2 7409 e8???????? }
            // n = 5, score = 100
            //   7410                 | je                  0x12
            //   8b55f4               | mov                 edx, dword ptr [ebp - 0xc]
            //   85d2                 | test                edx, edx
            //   7409                 | je                  0xb
            //   e8????????           |                     

        $sequence_3 = { 59 84db 750d 85f6 7416 56 e8???????? }
            // n = 7, score = 100
            //   59                   | pop                 ecx
            //   84db                 | test                bl, bl
            //   750d                 | jne                 0xf
            //   85f6                 | test                esi, esi
            //   7416                 | je                  0x18
            //   56                   | push                esi
            //   e8????????           |                     

        $sequence_4 = { 85db 0f840a010000 56 ff75ec }
            // n = 4, score = 100
            //   85db                 | test                ebx, ebx
            //   0f840a010000         | je                  0x110
            //   56                   | push                esi
            //   ff75ec               | push                dword ptr [ebp - 0x14]

        $sequence_5 = { 1bc0 23f8 0fb6875c204000 47 03c6 83c603 }
            // n = 6, score = 100
            //   1bc0                 | sbb                 eax, eax
            //   23f8                 | and                 edi, eax
            //   0fb6875c204000       | movzx               eax, byte ptr [edi + 0x40205c]
            //   47                   | inc                 edi
            //   03c6                 | add                 eax, esi
            //   83c603               | add                 esi, 3

        $sequence_6 = { 56 e8???????? 59 eb0d 8b45e8 8b4d08 }
            // n = 6, score = 100
            //   56                   | push                esi
            //   e8????????           |                     
            //   59                   | pop                 ecx
            //   eb0d                 | jmp                 0xf
            //   8b45e8               | mov                 eax, dword ptr [ebp - 0x18]
            //   8b4d08               | mov                 ecx, dword ptr [ebp + 8]

        $sequence_7 = { 85c0 7529 8b4dfc 85c9 }
            // n = 4, score = 100
            //   85c0                 | test                eax, eax
            //   7529                 | jne                 0x2b
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   85c9                 | test                ecx, ecx

        $sequence_8 = { 832600 832700 6a06 ebba }
            // n = 4, score = 100
            //   832600               | and                 dword ptr [esi], 0
            //   832700               | and                 dword ptr [edi], 0
            //   6a06                 | push                6
            //   ebba                 | jmp                 0xffffffbc

        $sequence_9 = { 50 ff75ec 8bfb ff15???????? 85c0 }
            // n = 5, score = 100
            //   50                   | push                eax
            //   ff75ec               | push                dword ptr [ebp - 0x14]
            //   8bfb                 | mov                 edi, ebx
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax

    condition:
        7 of them and filesize < 40960
}