rule win_unidentified_039_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_039."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_039"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 2bc8 034df4 81f1a1710000 894df8 8b45f4 8b4d0c 3bc8 }
            // n = 7, score = 100
            //   2bc8                 | sub                 ecx, eax
            //   034df4               | add                 ecx, dword ptr [ebp - 0xc]
            //   81f1a1710000         | xor                 ecx, 0x71a1
            //   894df8               | mov                 dword ptr [ebp - 8], ecx
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   8b4d0c               | mov                 ecx, dword ptr [ebp + 0xc]
            //   3bc8                 | cmp                 ecx, eax

        $sequence_1 = { 894dfc 8b45f4 8b4df8 3bc8 7d0c ff75f8 }
            // n = 6, score = 100
            //   894dfc               | mov                 dword ptr [ebp - 4], ecx
            //   8b45f4               | mov                 eax, dword ptr [ebp - 0xc]
            //   8b4df8               | mov                 ecx, dword ptr [ebp - 8]
            //   3bc8                 | cmp                 ecx, eax
            //   7d0c                 | jge                 0xe
            //   ff75f8               | push                dword ptr [ebp - 8]

        $sequence_2 = { 837ddc00 75e6 c6460401 830eff 8bc6 2b04bd20d24100 }
            // n = 6, score = 100
            //   837ddc00             | cmp                 dword ptr [ebp - 0x24], 0
            //   75e6                 | jne                 0xffffffe8
            //   c6460401             | mov                 byte ptr [esi + 4], 1
            //   830eff               | or                  dword ptr [esi], 0xffffffff
            //   8bc6                 | mov                 eax, esi
            //   2b04bd20d24100       | sub                 eax, dword ptr [edi*4 + 0x41d220]

        $sequence_3 = { c745d8d9580000 8b45dc 59 59 8b4de0 }
            // n = 5, score = 100
            //   c745d8d9580000       | mov                 dword ptr [ebp - 0x28], 0x58d9
            //   8b45dc               | mov                 eax, dword ptr [ebp - 0x24]
            //   59                   | pop                 ecx
            //   59                   | pop                 ecx
            //   8b4de0               | mov                 ecx, dword ptr [ebp - 0x20]

        $sequence_4 = { c7459c2e4c0000 c7459cd65d0000 8b459c 251f140000 89459c }
            // n = 5, score = 100
            //   c7459c2e4c0000       | mov                 dword ptr [ebp - 0x64], 0x4c2e
            //   c7459cd65d0000       | mov                 dword ptr [ebp - 0x64], 0x5dd6
            //   8b459c               | mov                 eax, dword ptr [ebp - 0x64]
            //   251f140000           | and                 eax, 0x141f
            //   89459c               | mov                 dword ptr [ebp - 0x64], eax

        $sequence_5 = { 0bc1 8945d8 8b45f0 8b4df4 3bc8 7c0c }
            // n = 6, score = 100
            //   0bc1                 | or                  eax, ecx
            //   8945d8               | mov                 dword ptr [ebp - 0x28], eax
            //   8b45f0               | mov                 eax, dword ptr [ebp - 0x10]
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   3bc8                 | cmp                 ecx, eax
            //   7c0c                 | jl                  0xe

        $sequence_6 = { 40 663bcb 75f6 6a25 2bc2 8d4d04 51 }
            // n = 7, score = 100
            //   40                   | inc                 eax
            //   663bcb               | cmp                 cx, bx
            //   75f6                 | jne                 0xfffffff8
            //   6a25                 | push                0x25
            //   2bc2                 | sub                 eax, edx
            //   8d4d04               | lea                 ecx, [ebp + 4]
            //   51                   | push                ecx

        $sequence_7 = { 6890010000 53 53 53 894538 }
            // n = 5, score = 100
            //   6890010000           | push                0x190
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   894538               | mov                 dword ptr [ebp + 0x38], eax

        $sequence_8 = { 0fafc1 8b4de8 2bc1 8b4dec 81e97f650000 33c1 8945f8 }
            // n = 7, score = 100
            //   0fafc1               | imul                eax, ecx
            //   8b4de8               | mov                 ecx, dword ptr [ebp - 0x18]
            //   2bc1                 | sub                 eax, ecx
            //   8b4dec               | mov                 ecx, dword ptr [ebp - 0x14]
            //   81e97f650000         | sub                 ecx, 0x657f
            //   33c1                 | xor                 eax, ecx
            //   8945f8               | mov                 dword ptr [ebp - 8], eax

        $sequence_9 = { 8b4dfc 0bc1 0d403a0000 8945f8 8b4508 8b4dfc 3bc8 }
            // n = 7, score = 100
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   0bc1                 | or                  eax, ecx
            //   0d403a0000           | or                  eax, 0x3a40
            //   8945f8               | mov                 dword ptr [ebp - 8], eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b4dfc               | mov                 ecx, dword ptr [ebp - 4]
            //   3bc8                 | cmp                 ecx, eax

    condition:
        7 of them and filesize < 262144
}