rule win_unidentified_045_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_045."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_045"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6800040000 53 53 681f000f00 50 }
            // n = 5, score = 100
            //   6800040000           | push                0x400
            //   53                   | push                ebx
            //   53                   | push                ebx
            //   681f000f00           | push                0xf001f
            //   50                   | push                eax

        $sequence_1 = { 83e70f 5b 83ff03 7205 83ff08 }
            // n = 5, score = 100
            //   83e70f               | and                 edi, 0xf
            //   5b                   | pop                 ebx
            //   83ff03               | cmp                 edi, 3
            //   7205                 | jb                  7
            //   83ff08               | cmp                 edi, 8

        $sequence_2 = { 33db 6a68 8d45b8 53 50 895d70 }
            // n = 6, score = 100
            //   33db                 | xor                 ebx, ebx
            //   6a68                 | push                0x68
            //   8d45b8               | lea                 eax, [ebp - 0x48]
            //   53                   | push                ebx
            //   50                   | push                eax
            //   895d70               | mov                 dword ptr [ebp + 0x70], ebx

        $sequence_3 = { 7517 ff7638 8b4810 e8???????? }
            // n = 4, score = 100
            //   7517                 | jne                 0x19
            //   ff7638               | push                dword ptr [esi + 0x38]
            //   8b4810               | mov                 ecx, dword ptr [eax + 0x10]
            //   e8????????           |                     

        $sequence_4 = { ff7510 8d45f0 56 6a0c 50 }
            // n = 5, score = 100
            //   ff7510               | push                dword ptr [ebp + 0x10]
            //   8d45f0               | lea                 eax, [ebp - 0x10]
            //   56                   | push                esi
            //   6a0c                 | push                0xc
            //   50                   | push                eax

        $sequence_5 = { ff7508 897dac 56 ff15???????? }
            // n = 4, score = 100
            //   ff7508               | push                dword ptr [ebp + 8]
            //   897dac               | mov                 dword ptr [ebp - 0x54], edi
            //   56                   | push                esi
            //   ff15????????         |                     

        $sequence_6 = { 8901 8b8538ffffff 8b0d???????? 8901 }
            // n = 4, score = 100
            //   8901                 | mov                 dword ptr [ecx], eax
            //   8b8538ffffff         | mov                 eax, dword ptr [ebp - 0xc8]
            //   8b0d????????         |                     
            //   8901                 | mov                 dword ptr [ecx], eax

        $sequence_7 = { 03f0 0500040000 894508 8d8ef8000000 3bc8 0f87d6030000 b850450000 }
            // n = 7, score = 100
            //   03f0                 | add                 esi, eax
            //   0500040000           | add                 eax, 0x400
            //   894508               | mov                 dword ptr [ebp + 8], eax
            //   8d8ef8000000         | lea                 ecx, [esi + 0xf8]
            //   3bc8                 | cmp                 ecx, eax
            //   0f87d6030000         | ja                  0x3dc
            //   b850450000           | mov                 eax, 0x4550

    condition:
        7 of them and filesize < 73728
}