rule win_unidentified_069_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_069."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_069"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d4564 e8???????? 84c0 747b 807d6802 7558 }
            // n = 6, score = 100
            //   8d4564               | lea                 eax, [ebp + 0x64]
            //   e8????????           |                     
            //   84c0                 | test                al, al
            //   747b                 | je                  0x7d
            //   807d6802             | cmp                 byte ptr [ebp + 0x68], 2
            //   7558                 | jne                 0x5a

        $sequence_1 = { 3975fc 0f824dffffff 5f 5b 8b450c 5e c9 }
            // n = 7, score = 100
            //   3975fc               | cmp                 dword ptr [ebp - 4], esi
            //   0f824dffffff         | jb                  0xffffff53
            //   5f                   | pop                 edi
            //   5b                   | pop                 ebx
            //   8b450c               | mov                 eax, dword ptr [ebp + 0xc]
            //   5e                   | pop                 esi
            //   c9                   | leave               

        $sequence_2 = { ff15???????? 8b7d08 8b37 e8???????? 83f8ff 0f84a8010000 8b0d???????? }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   8b7d08               | mov                 edi, dword ptr [ebp + 8]
            //   8b37                 | mov                 esi, dword ptr [edi]
            //   e8????????           |                     
            //   83f8ff               | cmp                 eax, -1
            //   0f84a8010000         | je                  0x1ae
            //   8b0d????????         |                     

        $sequence_3 = { 8b75f4 f6450804 741a 85f6 7616 8b7d0c 8d4477fe }
            // n = 7, score = 100
            //   8b75f4               | mov                 esi, dword ptr [ebp - 0xc]
            //   f6450804             | test                byte ptr [ebp + 8], 4
            //   741a                 | je                  0x1c
            //   85f6                 | test                esi, esi
            //   7616                 | jbe                 0x18
            //   8b7d0c               | mov                 edi, dword ptr [ebp + 0xc]
            //   8d4477fe             | lea                 eax, [edi + esi*2 - 2]

        $sequence_4 = { 7fae ff36 885dff ff15???????? 59 8a45ff 5f }
            // n = 7, score = 100
            //   7fae                 | jg                  0xffffffb0
            //   ff36                 | push                dword ptr [esi]
            //   885dff               | mov                 byte ptr [ebp - 1], bl
            //   ff15????????         |                     
            //   59                   | pop                 ecx
            //   8a45ff               | mov                 al, byte ptr [ebp - 1]
            //   5f                   | pop                 edi

        $sequence_5 = { 8bda d1eb 23df 8b1c9da81d4000 81e3ffffff01 03c0 }
            // n = 6, score = 100
            //   8bda                 | mov                 ebx, edx
            //   d1eb                 | shr                 ebx, 1
            //   23df                 | and                 ebx, edi
            //   8b1c9da81d4000       | mov                 ebx, dword ptr [ebx*4 + 0x401da8]
            //   81e3ffffff01         | and                 ebx, 0x1ffffff
            //   03c0                 | add                 eax, eax

        $sequence_6 = { c20400 8b462c 85c0 7638 83f820 7411 57 }
            // n = 7, score = 100
            //   c20400               | ret                 4
            //   8b462c               | mov                 eax, dword ptr [esi + 0x2c]
            //   85c0                 | test                eax, eax
            //   7638                 | jbe                 0x3a
            //   83f820               | cmp                 eax, 0x20
            //   7411                 | je                  0x13
            //   57                   | push                edi

        $sequence_7 = { 7505 895dd8 eb11 0fb7c0 03c7 50 83c8ff }
            // n = 7, score = 100
            //   7505                 | jne                 7
            //   895dd8               | mov                 dword ptr [ebp - 0x28], ebx
            //   eb11                 | jmp                 0x13
            //   0fb7c0               | movzx               eax, ax
            //   03c7                 | add                 eax, edi
            //   50                   | push                eax
            //   83c8ff               | or                  eax, 0xffffffff

        $sequence_8 = { e8???????? 8bf8 85ff 0f8e97000000 8bca e8???????? }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   85ff                 | test                edi, edi
            //   0f8e97000000         | jle                 0x9d
            //   8bca                 | mov                 ecx, edx
            //   e8????????           |                     

        $sequence_9 = { ff15???????? 85c0 7419 6a00 68???????? 6a05 ba???????? }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   85c0                 | test                eax, eax
            //   7419                 | je                  0x1b
            //   6a00                 | push                0
            //   68????????           |                     
            //   6a05                 | push                5
            //   ba????????           |                     

    condition:
        7 of them and filesize < 434176
}