rule win_unidentified_070_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_070."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_070"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 6a00 6a00 6a00 6a04 50 ff15???????? 8945fc }
            // n = 7, score = 300
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a04                 | push                4
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_1 = { 6a04 50 ff15???????? 8945fc 85c0 }
            // n = 5, score = 300
            //   6a04                 | push                4
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   85c0                 | test                eax, eax

        $sequence_2 = { 6a00 6a00 6a04 50 ff15???????? 8945fc 85c0 }
            // n = 7, score = 300
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a04                 | push                4
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   85c0                 | test                eax, eax

        $sequence_3 = { 6a00 6a04 50 ff15???????? 8945fc 85c0 }
            // n = 6, score = 300
            //   6a00                 | push                0
            //   6a04                 | push                4
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax
            //   85c0                 | test                eax, eax

        $sequence_4 = { 6a00 6a04 50 ff15???????? 8945fc }
            // n = 5, score = 300
            //   6a00                 | push                0
            //   6a04                 | push                4
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_5 = { 33c0 c20400 3b0d???????? 7502 }
            // n = 4, score = 300
            //   33c0                 | xor                 eax, eax
            //   c20400               | ret                 4
            //   3b0d????????         |                     
            //   7502                 | jne                 4

        $sequence_6 = { 6a00 6a00 6a04 50 ff15???????? 8945fc }
            // n = 6, score = 300
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6a04                 | push                4
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8945fc               | mov                 dword ptr [ebp - 4], eax

        $sequence_7 = { 83f8ff 50 0f95c3 ff15???????? 8d85f4fdffff }
            // n = 5, score = 200
            //   83f8ff               | cmp                 eax, -1
            //   50                   | push                eax
            //   0f95c3               | setne               bl
            //   ff15????????         |                     
            //   8d85f4fdffff         | lea                 eax, [ebp - 0x20c]

        $sequence_8 = { 6a00 6a00 6800200000 6a01 8d8424e8000000 }
            // n = 5, score = 200
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   6800200000           | push                0x2000
            //   6a01                 | push                1
            //   8d8424e8000000       | lea                 eax, [esp + 0xe8]

        $sequence_9 = { 6a00 6a00 68???????? 8d85f4fdffff 50 6a00 }
            // n = 6, score = 200
            //   6a00                 | push                0
            //   6a00                 | push                0
            //   68????????           |                     
            //   8d85f4fdffff         | lea                 eax, [ebp - 0x20c]
            //   50                   | push                eax
            //   6a00                 | push                0

    condition:
        7 of them and filesize < 90112
}