rule win_unidentified_071_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_071."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_071"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 837c241002 740b 837c241003 7504 6a0b }
            // n = 5, score = 400
            //   837c241002           | cmp                 dword ptr [esp + 0x10], 2
            //   740b                 | je                  0xd
            //   837c241003           | cmp                 dword ptr [esp + 0x10], 3
            //   7504                 | jne                 6
            //   6a0b                 | push                0xb

        $sequence_1 = { a1???????? 0d00020000 a3???????? e8???????? }
            // n = 4, score = 400
            //   a1????????           |                     
            //   0d00020000           | or                  eax, 0x200
            //   a3????????           |                     
            //   e8????????           |                     

        $sequence_2 = { 56 55 e8???????? 8d4701 89742420 }
            // n = 5, score = 400
            //   56                   | push                esi
            //   55                   | push                ebp
            //   e8????????           |                     
            //   8d4701               | lea                 eax, [edi + 1]
            //   89742420             | mov                 dword ptr [esp + 0x20], esi

        $sequence_3 = { c1e902 57 33ff 3b550c 0f47c8 85c9 7413 }
            // n = 7, score = 400
            //   c1e902               | shr                 ecx, 2
            //   57                   | push                edi
            //   33ff                 | xor                 edi, edi
            //   3b550c               | cmp                 edx, dword ptr [ebp + 0xc]
            //   0f47c8               | cmova               ecx, eax
            //   85c9                 | test                ecx, ecx
            //   7413                 | je                  0x15

        $sequence_4 = { 53 56 57 e8???????? 83c418 eb10 83f802 }
            // n = 7, score = 400
            //   53                   | push                ebx
            //   56                   | push                esi
            //   57                   | push                edi
            //   e8????????           |                     
            //   83c418               | add                 esp, 0x18
            //   eb10                 | jmp                 0x12
            //   83f802               | cmp                 eax, 2

        $sequence_5 = { 3bf3 7408 53 8bce e8???????? 83ed10 83eb10 }
            // n = 7, score = 400
            //   3bf3                 | cmp                 esi, ebx
            //   7408                 | je                  0xa
            //   53                   | push                ebx
            //   8bce                 | mov                 ecx, esi
            //   e8????????           |                     
            //   83ed10               | sub                 ebp, 0x10
            //   83eb10               | sub                 ebx, 0x10

        $sequence_6 = { 0faf05???????? 53 56 8b35???????? }
            // n = 4, score = 400
            //   0faf05????????       |                     
            //   53                   | push                ebx
            //   56                   | push                esi
            //   8b35????????         |                     

        $sequence_7 = { 8bec 8b550c 8b4d10 8b4214 2b4210 394110 7615 }
            // n = 7, score = 400
            //   8bec                 | mov                 ebp, esp
            //   8b550c               | mov                 edx, dword ptr [ebp + 0xc]
            //   8b4d10               | mov                 ecx, dword ptr [ebp + 0x10]
            //   8b4214               | mov                 eax, dword ptr [edx + 0x14]
            //   2b4210               | sub                 eax, dword ptr [edx + 0x10]
            //   394110               | cmp                 dword ptr [ecx + 0x10], eax
            //   7615                 | jbe                 0x17

        $sequence_8 = { c21000 e8???????? cc 8b442408 56 8b742408 }
            // n = 6, score = 400
            //   c21000               | ret                 0x10
            //   e8????????           |                     
            //   cc                   | int3                
            //   8b442408             | mov                 eax, dword ptr [esp + 8]
            //   56                   | push                esi
            //   8b742408             | mov                 esi, dword ptr [esp + 8]

        $sequence_9 = { a3???????? a1???????? 83e040 59 a3???????? }
            // n = 5, score = 400
            //   a3????????           |                     
            //   a1????????           |                     
            //   83e040               | and                 eax, 0x40
            //   59                   | pop                 ecx
            //   a3????????           |                     

    condition:
        7 of them and filesize < 1220608
}