rule win_unidentified_077_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_077."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_077"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8d4210 83c220 f30f6f0418 660fefc1 f30f7f0418 413bd1 }
            // n = 6, score = 600
            //   8d4210               | dec                 eax
            //   83c220               | lea                 edx, [0xe238]
            //   f30f6f0418           | dec                 eax
            //   660fefc1             | mov                 eax, ecx
            //   f30f7f0418           | and                 ecx, 0x3f
            //   413bd1               | dec                 eax

        $sequence_1 = { 48894640 488d05a1fcffff 48894648 8b442424 }
            // n = 4, score = 600
            //   48894640             | arpl                di, bx
            //   488d05a1fcffff       | dec                 eax
            //   48894648             | lea                 ecx, [0x12f5c]
            //   8b442424             | dec                 eax

        $sequence_2 = { 4933f8 4a87bcf1a0bf0100 33c0 488b5c2450 488b6c2458 488b742460 }
            // n = 6, score = 600
            //   4933f8               | dec                 eax
            //   4a87bcf1a0bf0100     | mov                 dword ptr [esp + 8], ebx
            //   33c0                 | dec                 eax
            //   488b5c2450           | mov                 dword ptr [esp + 0x10], esi
            //   488b6c2458           | push                edi
            //   488b742460           | dec                 eax

        $sequence_3 = { 4c8d442470 897c2470 488d542468 897c2468 488bcb e8???????? 85c0 }
            // n = 7, score = 600
            //   4c8d442470           | dec                 eax
            //   897c2470             | add                 eax, 0x24
            //   488d542468           | mov                 dword ptr [eax], edi
            //   897c2468             | dec                 eax
            //   488bcb               | lea                 ebx, [0x15583]
            //   e8????????           |                     
            //   85c0                 | dec                 eax

        $sequence_4 = { 498bc6 4823cb 4823c3 483bc1 7354 6690 b910000000 }
            // n = 7, score = 600
            //   498bc6               | inc                 ecx
            //   4823cb               | mov                 edi, ecx
            //   4823c3               | dec                 ecx
            //   483bc1               | mov                 esi, eax
            //   7354                 | mov                 ebp, edx
            //   6690                 | dec                 esp
            //   b910000000           | lea                 ecx, [0x9d70]

        $sequence_5 = { e8???????? 85c0 0f85c6000000 448b442468 }
            // n = 4, score = 600
            //   e8????????           |                     
            //   85c0                 | lea                 ecx, [0x9e14]
            //   0f85c6000000         | push                edi
            //   448b442468           | dec                 eax

        $sequence_6 = { 488b8dd00c0000 4833cc e8???????? 4881c4f80d0000 415f 415d 415c }
            // n = 7, score = 600
            //   488b8dd00c0000       | mov                 edi, eax
            //   4833cc               | xor                 edx, edx
            //   e8????????           |                     
            //   4881c4f80d0000       | dec                 eax
            //   415f                 | shl                 ebx, 2
            //   415d                 | inc                 ecx
            //   415c                 | lea                 eax, [esi + 1]

        $sequence_7 = { 33c0 488bb424a0000000 4c8bb424a8000000 488bac2498000000 4c8b7c2460 488b4c2450 }
            // n = 6, score = 600
            //   33c0                 | mulsd               xmm3, xmm2
            //   488bb424a0000000     | movapd              xmm2, xmm1
            //   4c8bb424a8000000     | movapd              xmm0, xmm1
            //   488bac2498000000     | dec                 esp
            //   4c8b7c2460           | lea                 ecx, [0x917b]
            //   488b4c2450           | movapd              xmm2, xmm1

        $sequence_8 = { 751b ff15???????? 488bce 418907 }
            // n = 4, score = 600
            //   751b                 | and                 ecx, 0x3f
            //   ff15????????         |                     
            //   488bce               | dec                 eax
            //   418907               | sar                 eax, 6

        $sequence_9 = { 488d0592fcffff 48894630 488d0597fcffff 48894638 488d059cfcffff 48894640 }
            // n = 6, score = 600
            //   488d0592fcffff       | dec                 eax
            //   48894630             | sar                 eax, 6
            //   488d0597fcffff       | dec                 eax
            //   48894638             | shl                 edx, 6
            //   488d059cfcffff       | dec                 eax
            //   48894640             | arpl                si, dx

    condition:
        7 of them and filesize < 270336
}