rule win_unidentified_078_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_078."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_078"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0f8412010000 0f8cee000000 80fa0d 0f8421010000 80fa1b 0f8576010000 }
            // n = 6, score = 200
            //   0f8412010000         | mov                 ecx, eax
            //   0f8cee000000         | dec                 eax
            //   80fa0d               | add                 esp, 0x28
            //   0f8421010000         | dec                 eax
            //   80fa1b               | mov                 ecx, eax
            //   0f8576010000         | dec                 eax

        $sequence_1 = { 0f8d94010000 80fa26 0f8f18010000 80fa23 0f8d82010000 }
            // n = 5, score = 200
            //   0f8d94010000         | jmp                 0x416
            //   80fa26               | call                dword ptr [edi + ebx*8]
            //   0f8f18010000         | dec                 eax
            //   80fa23               | lea                 esi, [eax - 1]
            //   0f8d82010000         | jmp                 0x436

        $sequence_2 = { 80fa5c 0f94c1 80fa2f 0f94c2 08d1 }
            // n = 5, score = 200
            //   80fa5c               | mov                 eax, edx
            //   0f94c1               | not                 eax
            //   80fa2f               | inc                 ecx
            //   0f94c2               | and                 eax, dword ptr [ecx + 0x1014]
            //   08d1                 | dec                 ecx

        $sequence_3 = { 3c18 0f8483000000 3c1c 740d 3c16 }
            // n = 5, score = 200
            //   3c18                 | mov                 dword ptr [esp + 0x20], 0
            //   0f8483000000         | dec                 ecx
            //   3c1c                 | mov                 eax, ecx
            //   740d                 | xor                 ecx, ecx
            //   3c16                 | mov                 dword ptr [esp + 0x20], 0

        $sequence_4 = { e9???????? 80fa0c 0f8412010000 0f8cee000000 80fa0d }
            // n = 5, score = 200
            //   e9????????           |                     
            //   80fa0c               | lea                 esi, [0x7067]
            //   0f8412010000         | mov                 ecx, 7
            //   0f8cee000000         | dec                 eax
            //   80fa0d               | add                 edx, 0x1c

        $sequence_5 = { 89d6 0f883a020000 80fa21 0f8f8f000000 80fa20 0f8d28020000 }
            // n = 6, score = 200
            //   89d6                 | inc                 ecx
            //   0f883a020000         | mov                 esp, 0xa
            //   80fa21               | je                  0x18fb
            //   0f8f8f000000         | dec                 ecx
            //   80fa20               | mov                 eax, dword ptr [ecx]
            //   0f8d28020000         | dec                 eax

        $sequence_6 = { a910000108 753f a900004011 7521 a900000600 7467 }
            // n = 6, score = 200
            //   a910000108           | test                eax, eax
            //   753f                 | dec                 eax
            //   a900004011           | lea                 ecx, [0x77b8]
            //   7521                 | dec                 eax
            //   a900000600           | test                eax, eax
            //   7467                 | dec                 eax

        $sequence_7 = { ff15???????? 85c0 740e e8???????? 31d2 89c1 e8???????? }
            // n = 7, score = 200
            //   ff15????????         |                     
            //   85c0                 | dec                 eax
            //   740e                 | sub                 esp, 0x28
            //   e8????????           |                     
            //   31d2                 | inc                 ecx
            //   89c1                 | mov                 ecx, 4
            //   e8????????           |                     

        $sequence_8 = { b901010000 ff15???????? 85c0 740e }
            // n = 4, score = 200
            //   b901010000           | mov                 ecx, eax
            //   ff15????????         |                     
            //   85c0                 | cmp                 ecx, 7
            //   740e                 | ja                  0xfe

        $sequence_9 = { 0f8421010000 80fa1b 0f8576010000 ba02000000 e8???????? }
            // n = 5, score = 200
            //   0f8421010000         | sub                 edx, eax
            //   80fa1b               | dec                 ecx
            //   0f8576010000         | lea                 ebx, [ecx + esi]
            //   ba02000000           | dec                 esp
            //   e8????????           |                     

    condition:
        7 of them and filesize < 688128
}