rule win_unidentified_087_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_087."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_087"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 498bdd 666666666666660f1f840000000000 0fb6941c98000000 498bcf e8???????? }
            // n = 5, score = 200
            //   498bdd               | dec                 ecx
            //   666666666666660f1f840000000000     | mov    ebx, ebp
            //   0fb6941c98000000     | nop                 word ptr [eax + eax]
            //   498bcf               | movzx               edx, byte ptr [esp + ebx + 0x98]
            //   e8????????           |                     

        $sequence_1 = { 41b900000008 4533c0 488d5560 33c9 ff15???????? 488bf8 4885c0 }
            // n = 7, score = 200
            //   41b900000008         | or                  edx, 4
            //   4533c0               | inc                 ebp
            //   488d5560             | xor                 eax, eax
            //   33c9                 | dec                 eax
            //   ff15????????         |                     
            //   488bf8               | mov                 eax, dword ptr [esp + 0x50]
            //   4885c0               | dec                 eax

        $sequence_2 = { c7457001000000 c7457c02000000 488d4580 4889442428 488d85a8000000 }
            // n = 5, score = 200
            //   c7457001000000       | cmp                 ebx, 1
            //   c7457c02000000       | jb                  0x9d
            //   488d4580             | dec                 eax
            //   4889442428           | lea                 ebp, [0x29a0e]
            //   488d85a8000000       | inc                 ecx

        $sequence_3 = { 4885c9 7407 ff15???????? 90 4885db }
            // n = 5, score = 200
            //   4885c9               | lea                 edx, [ebp + 0x60]
            //   7407                 | xor                 ecx, ecx
            //   ff15????????         |                     
            //   90                   | dec                 eax
            //   4885db               | mov                 edi, eax

        $sequence_4 = { 488d0c38 4d8bc7 4903cc 4803d5 e8???????? }
            // n = 5, score = 200
            //   488d0c38             | mov                 ecx, 0x8000000
            //   4d8bc7               | inc                 ebp
            //   4903cc               | xor                 eax, eax
            //   4803d5               | dec                 eax
            //   e8????????           |                     

        $sequence_5 = { 4883794800 7503 83ca04 4533c0 e8???????? 488b442450 }
            // n = 6, score = 200
            //   4883794800           | dec                 ecx
            //   7503                 | lea                 edi, [ebx + 1]
            //   83ca04               | dec                 esp
            //   4533c0               | mov                 eax, ebx
            //   e8????????           |                     
            //   488b442450           | mov                 edx, ebp

        $sequence_6 = { 4883fb01 0f8288000000 488d2d0e9a0200 48833d????????10 480f432d???????? }
            // n = 5, score = 200
            //   4883fb01             | dec                 eax
            //   0f8288000000         | cmp                 dword ptr [ecx + 0x48], 0
            //   488d2d0e9a0200       | jne                 0xa
            //   48833d????????10     |                     
            //   480f432d????????     |                     

        $sequence_7 = { 488d5c3bff 498d7b01 4c8bc3 8bd5 }
            // n = 4, score = 200
            //   488d5c3bff           | dec                 ecx
            //   498d7b01             | mov                 ecx, edi
            //   4c8bc3               | dec                 eax
            //   8bd5                 | lea                 ebx, [ebx + edi - 1]

        $sequence_8 = { 50 56 68???????? 57 ff15???????? 3b442410 7414 }
            // n = 7, score = 100
            //   50                   | push                eax
            //   56                   | push                esi
            //   68????????           |                     
            //   57                   | push                edi
            //   ff15????????         |                     
            //   3b442410             | cmp                 eax, dword ptr [esp + 0x10]
            //   7414                 | je                  0x16

        $sequence_9 = { c78550fbffff94000000 8d8d50fbffff 51 ff15???????? }
            // n = 4, score = 100
            //   c78550fbffff94000000     | mov    dword ptr [ebp - 0x4b0], 0x94
            //   8d8d50fbffff         | lea                 ecx, [ebp - 0x4b0]
            //   51                   | push                ecx
            //   ff15????????         |                     

        $sequence_10 = { 3c58 770f 0fbec2 0fbe80c8b10110 }
            // n = 4, score = 100
            //   3c58                 | cmp                 al, 0x58
            //   770f                 | ja                  0x11
            //   0fbec2               | movsx               eax, dl
            //   0fbe80c8b10110       | movsx               eax, byte ptr [eax + 0x1001b1c8]

        $sequence_11 = { 7429 8b5508 39542410 7412 8d442408 50 }
            // n = 6, score = 100
            //   7429                 | je                  0x2b
            //   8b5508               | mov                 edx, dword ptr [ebp + 8]
            //   39542410             | cmp                 dword ptr [esp + 0x10], edx
            //   7412                 | je                  0x14
            //   8d442408             | lea                 eax, [esp + 8]
            //   50                   | push                eax

        $sequence_12 = { 52 ff15???????? 32c0 e9???????? 8d8550ffffff }
            // n = 5, score = 100
            //   52                   | push                edx
            //   ff15????????         |                     
            //   32c0                 | xor                 al, al
            //   e9????????           |                     
            //   8d8550ffffff         | lea                 eax, [ebp - 0xb0]

        $sequence_13 = { 57 52 53 50 ff15???????? 8b8c242c040000 }
            // n = 6, score = 100
            //   57                   | push                edi
            //   52                   | push                edx
            //   53                   | push                ebx
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8b8c242c040000       | mov                 ecx, dword ptr [esp + 0x42c]

        $sequence_14 = { e8???????? 8bdc 57 68???????? 8d4e01 e8???????? }
            // n = 6, score = 100
            //   e8????????           |                     
            //   8bdc                 | mov                 ebx, esp
            //   57                   | push                edi
            //   68????????           |                     
            //   8d4e01               | lea                 ecx, [esi + 1]
            //   e8????????           |                     

        $sequence_15 = { 0f840c010000 8b0d???????? 8b7c2458 8d44240c }
            // n = 4, score = 100
            //   0f840c010000         | je                  0x112
            //   8b0d????????         |                     
            //   8b7c2458             | mov                 edi, dword ptr [esp + 0x58]
            //   8d44240c             | lea                 eax, [esp + 0xc]

    condition:
        7 of them and filesize < 462848
}