rule win_unidentified_088_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_088."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_088"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 8b0e e8???????? 89c7 31c0 85f6 7402 8b06 }
            // n = 7, score = 100
            //   8b0e                 | mov                 ecx, dword ptr [esi]
            //   e8????????           |                     
            //   89c7                 | mov                 edi, eax
            //   31c0                 | xor                 eax, eax
            //   85f6                 | test                esi, esi
            //   7402                 | je                  4
            //   8b06                 | mov                 eax, dword ptr [esi]

        $sequence_1 = { 8b0a 0faf0e 01c6 e9???????? 3b5de0 0f8f78010000 8b470c }
            // n = 7, score = 100
            //   8b0a                 | mov                 ecx, dword ptr [edx]
            //   0faf0e               | imul                ecx, dword ptr [esi]
            //   01c6                 | add                 esi, eax
            //   e9????????           |                     
            //   3b5de0               | cmp                 ebx, dword ptr [ebp - 0x20]
            //   0f8f78010000         | jg                  0x17e
            //   8b470c               | mov                 eax, dword ptr [edi + 0xc]

        $sequence_2 = { c74424085b040000 8b4dd4 ba???????? c7442404???????? c70424???????? e8???????? 83ec0c }
            // n = 7, score = 100
            //   c74424085b040000     | mov                 dword ptr [esp + 8], 0x45b
            //   8b4dd4               | mov                 ecx, dword ptr [ebp - 0x2c]
            //   ba????????           |                     
            //   c7442404????????     |                     
            //   c70424????????       |                     
            //   e8????????           |                     
            //   83ec0c               | sub                 esp, 0xc

        $sequence_3 = { 8b08 e8???????? 8945a0 8b4508 8b00 8b00 85c0 }
            // n = 7, score = 100
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   e8????????           |                     
            //   8945a0               | mov                 dword ptr [ebp - 0x60], eax
            //   8b4508               | mov                 eax, dword ptr [ebp + 8]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   8b00                 | mov                 eax, dword ptr [eax]
            //   85c0                 | test                eax, eax

        $sequence_4 = { c78564ffffff00000000 eb62 76bb 89c7 890424 c1ff1f c744241017000000 }
            // n = 7, score = 100
            //   c78564ffffff00000000     | mov    dword ptr [ebp - 0x9c], 0
            //   eb62                 | jmp                 0x64
            //   76bb                 | jbe                 0xffffffbd
            //   89c7                 | mov                 edi, eax
            //   890424               | mov                 dword ptr [esp], eax
            //   c1ff1f               | sar                 edi, 0x1f
            //   c744241017000000     | mov                 dword ptr [esp + 0x10], 0x17

        $sequence_5 = { b8a1b0b912 8b4dd0 83cbff 8901 85f6 0f849a000000 8b16 }
            // n = 7, score = 100
            //   b8a1b0b912           | mov                 eax, 0x12b9b0a1
            //   8b4dd0               | mov                 ecx, dword ptr [ebp - 0x30]
            //   83cbff               | or                  ebx, 0xffffffff
            //   8901                 | mov                 dword ptr [ecx], eax
            //   85f6                 | test                esi, esi
            //   0f849a000000         | je                  0xa0
            //   8b16                 | mov                 edx, dword ptr [esi]

        $sequence_6 = { c745d400000000 31db 8945bc 8b4dbc 394dd4 7c17 }
            // n = 6, score = 100
            //   c745d400000000       | mov                 dword ptr [ebp - 0x2c], 0
            //   31db                 | xor                 ebx, ebx
            //   8945bc               | mov                 dword ptr [ebp - 0x44], eax
            //   8b4dbc               | mov                 ecx, dword ptr [ebp - 0x44]
            //   394dd4               | cmp                 dword ptr [ebp - 0x2c], ecx
            //   7c17                 | jl                  0x19

        $sequence_7 = { e8???????? eb2e 898554ffffff e8???????? 8b8554ffffff 83f816 7ed2 }
            // n = 7, score = 100
            //   e8????????           |                     
            //   eb2e                 | jmp                 0x30
            //   898554ffffff         | mov                 dword ptr [ebp - 0xac], eax
            //   e8????????           |                     
            //   8b8554ffffff         | mov                 eax, dword ptr [ebp - 0xac]
            //   83f816               | cmp                 eax, 0x16
            //   7ed2                 | jle                 0xffffffd4

        $sequence_8 = { c21000 55 b9???????? 89e5 83ec08 e8???????? b9???????? }
            // n = 7, score = 100
            //   c21000               | ret                 0x10
            //   55                   | push                ebp
            //   b9????????           |                     
            //   89e5                 | mov                 ebp, esp
            //   83ec08               | sub                 esp, 8
            //   e8????????           |                     
            //   b9????????           |                     

        $sequence_9 = { 83ec0c e8???????? 8b4dc0 8b5dc4 8d75d8 }
            // n = 5, score = 100
            //   83ec0c               | sub                 esp, 0xc
            //   e8????????           |                     
            //   8b4dc0               | mov                 ecx, dword ptr [ebp - 0x40]
            //   8b5dc4               | mov                 ebx, dword ptr [ebp - 0x3c]
            //   8d75d8               | lea                 esi, [ebp - 0x28]

    condition:
        7 of them and filesize < 919552
}