rule win_unidentified_091_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_091."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_091"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 81e1ff00ff00 0bd1 895618 418b481c 8bd1 c1ca08 c1c108 }
            // n = 7, score = 100
            //   81e1ff00ff00         | shr                 edx, 1
            //   0bd1                 | lea                 eax, [edx + edx*2]
            //   895618               | inc                 esp
            //   418b481c             | sub                 ebx, eax
            //   8bd1                 | inc                 esp
            //   c1ca08               | add                 ebx, ebx
            //   c1c108               | inc                 ebx

        $sequence_1 = { c0e904 8885f8000000 888df9000000 0fb64a1d 0fb6c1 c0e904 240f }
            // n = 7, score = 100
            //   c0e904               | cmp                 eax, ebp
            //   8885f8000000         | je                  0x120b
            //   888df9000000         | inc                 ecx
            //   0fb64a1d             | mov                 ecx, eax
            //   0fb6c1               | dec                 eax
            //   c0e904               | add                 ecx, ecx
            //   240f                 | inc                 esp

        $sequence_2 = { e8???????? 85c0 743c 48ffc3 483b5c2430 72c4 488bcf }
            // n = 7, score = 100
            //   e8????????           |                     
            //   85c0                 | mov                 ecx, dword ptr [esp + 0x30]
            //   743c                 | dec                 eax
            //   48ffc3               | test                ecx, ecx
            //   483b5c2430           | je                  0x175
            //   72c4                 | dec                 ebp
            //   488bcf               | test                eax, eax

        $sequence_3 = { 8b442448 418bd1 4133d2 c1ca10 03fa 893c24 448bc7 }
            // n = 7, score = 100
            //   8b442448             | je                  0x19f4
            //   418bd1               | mov                 eax, dword ptr [esp + 0x48]
            //   4133d2               | dec                 eax
            //   c1ca10               | lea                 edx, [0xdb8bf]
            //   03fa                 | inc                 esp
            //   893c24               | mov                 eax, esi
            //   448bc7               | inc                 ebp

        $sequence_4 = { c1cd02 c1e718 418bc0 c1c005 4103c2 4489642418 03d0 }
            // n = 7, score = 100
            //   c1cd02               | dec                 eax
            //   c1e718               | lea                 ecx, [0x111101]
            //   418bc0               | dec                 esp
            //   c1c005               | cmp                 ebx, ecx
            //   4103c2               | jl                  0xfffff672
            //   4489642418           | dec                 eax
            //   03d0                 | mov                 ecx, dword ptr [esp + 0x110]

        $sequence_5 = { 85c0 0f8eee000000 488d0d49421600 48894d00 48215508 48215510 ffc0 }
            // n = 7, score = 100
            //   85c0                 | je                  0xa62
            //   0f8eee000000         | dec                 esp
            //   488d0d49421600       | mov                 dword ptr [esp + 0x20], esp
            //   48894d00             | dec                 esp
            //   48215508             | lea                 ecx, [ebp - 0x78]
            //   48215510             | inc                 ebp
            //   ffc0                 | mov                 eax, edi

        $sequence_6 = { e8???????? 488bd3 488bcf 4c8bf0 8b30 c70000000000 e8???????? }
            // n = 7, score = 100
            //   e8????????           |                     
            //   488bd3               | dec                 eax
            //   488bcf               | cmp                 eax, 4
            //   4c8bf0               | jb                  0x9ea
            //   8b30                 | inc                 esp
            //   c70000000000         | mov                 esi, ecx
            //   e8????????           |                     

        $sequence_7 = { f30f58d0 0f57c0 0fc6d200 0f51ca 410fc2d304 0fc2c104 0f5ed9 }
            // n = 7, score = 100
            //   f30f58d0             | movups              xmmword ptr [ebp - 0x19], xmm1
            //   0f57c0               | movups              xmm1, xmmword ptr [edx + 0x30]
            //   0fc6d200             | inc                 esp
            //   0f51ca               | mov                 edx, dword ptr [ebp - 0x11]
            //   410fc2d304           | inc                 esp
            //   0fc2c104             | mov                 ecx, dword ptr [ebp - 0x15]
            //   0f5ed9               | inc                 esp

        $sequence_8 = { 4c894507 48894d0f e9???????? c74424285a0a0000 ba50000000 4c89542420 41b966010000 }
            // n = 7, score = 100
            //   4c894507             | inc                 ecx
            //   48894d0f             | mov                 eax, 0x200
            //   e9????????           |                     
            //   c74424285a0a0000     | dec                 eax
            //   ba50000000           | lea                 ecx, [ebp + 0x3e0]
            //   4c89542420           | jne                 0x11db
            //   41b966010000         | dec                 esp

        $sequence_9 = { c784248000000001000000 eb32 c7442420f6010000 baa6000000 4c8d0db8a71100 b906000000 448d42fc }
            // n = 7, score = 100
            //   c784248000000001000000     | dec    eax
            //   eb32                 | lea                 ecx, [0x1942a5]
            //   c7442420f6010000     | dec                 esp
            //   baa6000000           | mov                 eax, edi
            //   4c8d0db8a71100       | dec                 eax
            //   b906000000           | test                eax, eax
            //   448d42fc             | dec                 eax

    condition:
        7 of them and filesize < 5777408
}