rule win_unidentified_092_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_092."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_092"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 50 8b08 ff511c c745fcffffffff 83ceff 8b7db4 }
            // n = 6, score = 100
            //   50                   | push                eax
            //   8b08                 | mov                 ecx, dword ptr [eax]
            //   ff511c               | call                dword ptr [ecx + 0x1c]
            //   c745fcffffffff       | mov                 dword ptr [ebp - 4], 0xffffffff
            //   83ceff               | or                  esi, 0xffffffff
            //   8b7db4               | mov                 edi, dword ptr [ebp - 0x4c]

        $sequence_1 = { e8???????? 83bd94f6ffff08 8d8d98f5ffff 8d8580f6ffff 0f438580f6ffff 51 }
            // n = 6, score = 100
            //   e8????????           |                     
            //   83bd94f6ffff08       | cmp                 dword ptr [ebp - 0x96c], 8
            //   8d8d98f5ffff         | lea                 ecx, [ebp - 0xa68]
            //   8d8580f6ffff         | lea                 eax, [ebp - 0x980]
            //   0f438580f6ffff       | cmovae              eax, dword ptr [ebp - 0x980]
            //   51                   | push                ecx

        $sequence_2 = { 57 6a00 ff15???????? 50 ff15???????? 8bc3 8b4df4 }
            // n = 7, score = 100
            //   57                   | push                edi
            //   6a00                 | push                0
            //   ff15????????         |                     
            //   50                   | push                eax
            //   ff15????????         |                     
            //   8bc3                 | mov                 eax, ebx
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]

        $sequence_3 = { 8d8d14f6ffff e8???????? 8d8d14f6ffff 8ad8 e8???????? 84db 0f84b0000000 }
            // n = 7, score = 100
            //   8d8d14f6ffff         | lea                 ecx, [ebp - 0x9ec]
            //   e8????????           |                     
            //   8d8d14f6ffff         | lea                 ecx, [ebp - 0x9ec]
            //   8ad8                 | mov                 bl, al
            //   e8????????           |                     
            //   84db                 | test                bl, bl
            //   0f84b0000000         | je                  0xb6

        $sequence_4 = { 8b5ddc 03ca 23c7 8bd3 0bf0 c1ca0b 03f1 }
            // n = 7, score = 100
            //   8b5ddc               | mov                 ebx, dword ptr [ebp - 0x24]
            //   03ca                 | add                 ecx, edx
            //   23c7                 | and                 eax, edi
            //   8bd3                 | mov                 edx, ebx
            //   0bf0                 | or                  esi, eax
            //   c1ca0b               | ror                 edx, 0xb
            //   03f1                 | add                 esi, ecx

        $sequence_5 = { 8b470c 89460c 8b4710 894610 c745fc00000000 8d4e14 c706???????? }
            // n = 7, score = 100
            //   8b470c               | mov                 eax, dword ptr [edi + 0xc]
            //   89460c               | mov                 dword ptr [esi + 0xc], eax
            //   8b4710               | mov                 eax, dword ptr [edi + 0x10]
            //   894610               | mov                 dword ptr [esi + 0x10], eax
            //   c745fc00000000       | mov                 dword ptr [ebp - 4], 0
            //   8d4e14               | lea                 ecx, [esi + 0x14]
            //   c706????????         |                     

        $sequence_6 = { c1c10a c1ca0d 33d1 895dfc 8b4df4 c1c902 33d1 }
            // n = 7, score = 100
            //   c1c10a               | rol                 ecx, 0xa
            //   c1ca0d               | ror                 edx, 0xd
            //   33d1                 | xor                 edx, ecx
            //   895dfc               | mov                 dword ptr [ebp - 4], ebx
            //   8b4df4               | mov                 ecx, dword ptr [ebp - 0xc]
            //   c1c902               | ror                 ecx, 2
            //   33d1                 | xor                 edx, ecx

        $sequence_7 = { 8d8db8fdffff 81e37fffffff e8???????? f6c340 }
            // n = 4, score = 100
            //   8d8db8fdffff         | lea                 ecx, [ebp - 0x248]
            //   81e37fffffff         | and                 ebx, 0xffffff7f
            //   e8????????           |                     
            //   f6c340               | test                bl, 0x40

        $sequence_8 = { ffd7 8bf8 897dd4 eb03 8b7dd4 }
            // n = 5, score = 100
            //   ffd7                 | call                edi
            //   8bf8                 | mov                 edi, eax
            //   897dd4               | mov                 dword ptr [ebp - 0x2c], edi
            //   eb03                 | jmp                 5
            //   8b7dd4               | mov                 edi, dword ptr [ebp - 0x2c]

        $sequence_9 = { 51 8bd0 8d8d68fbffff e8???????? 8bf8 83c410 8d045b }
            // n = 7, score = 100
            //   51                   | push                ecx
            //   8bd0                 | mov                 edx, eax
            //   8d8d68fbffff         | lea                 ecx, [ebp - 0x498]
            //   e8????????           |                     
            //   8bf8                 | mov                 edi, eax
            //   83c410               | add                 esp, 0x10
            //   8d045b               | lea                 eax, [ebx + ebx*2]

    condition:
        7 of them and filesize < 10202112
}