rule win_unidentified_095_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_095."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_095"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4c8d0590ea0000 488d1541dd0000 e8???????? 4885c0 740f 488bcb 4883c420 }
            // n = 7, score = 100
            //   4c8d0590ea0000       | ret                 
            //   488d1541dd0000       | dec                 eax
            //   e8????????           |                     
            //   4885c0               | lea                 eax, [esp + 0x60]
            //   740f                 | mov                 eax, edi
            //   488bcb               | dec                 eax
            //   4883c420             | mov                 edi, dword ptr [esp + 0x38]

        $sequence_1 = { 488d15f0e80100 488d0df5e80100 e8???????? eb2e 803875 }
            // n = 5, score = 100
            //   488d15f0e80100       | movzx               eax, word ptr [ebx + edx*2 + 2]
            //   488d0df5e80100       | mov                 word ptr [ecx + edx*2], ax
            //   e8????????           |                     
            //   eb2e                 | dec                 eax
            //   803875               | lea                 edx, [edx + 1]

        $sequence_2 = { 7419 4c8d442420 ba01000000 488bcb ff15???????? 85c0 }
            // n = 6, score = 100
            //   7419                 | dec                 eax
            //   4c8d442420           | test                eax, eax
            //   ba01000000           | xor                 ecx, ecx
            //   488bcb               | mov                 edi, 1
            //   ff15????????         |                     
            //   85c0                 | test                esi, esi

        $sequence_3 = { 4d3bc1 0f84d1000000 8b7500 498b9cf7b8410200 90 4885db 740b }
            // n = 7, score = 100
            //   4d3bc1               | dec                 eax
            //   0f84d1000000         | test                eax, eax
            //   8b7500               | je                  0xc1b
            //   498b9cf7b8410200     | inc                 esp
            //   90                   | lea                 eax, [edi + 0x20]
            //   4885db               | mov                 ebp, eax
            //   740b                 | dec                 eax

        $sequence_4 = { 498bcc 488b9424c0000000 48896c2460 48896c2458 48896c2450 48896c2448 4889442440 }
            // n = 7, score = 100
            //   498bcc               | test                eax, eax
            //   488b9424c0000000     | je                  0x194f
            //   48896c2460           | inc                 esp
            //   48896c2458           | mov                 eax, ebx
            //   48896c2450           | dec                 eax
            //   48896c2448           | lea                 edx, [0xeccd]
            //   4889442440           | dec                 ecx

        $sequence_5 = { 752e 48895c2430 448d4303 895c2428 488d0d67a00000 4533c9 4489442420 }
            // n = 7, score = 100
            //   752e                 | mov                 ecx, dword ptr [esp + 0x840]
            //   48895c2430           | dec                 eax
            //   448d4303             | xor                 ecx, esp
            //   895c2428             | test                eax, eax
            //   488d0d67a00000       | je                  0x6d4
            //   4533c9               | cmp                 dword ptr [esp + 0x30], 5
            //   4489442420           | jne                 0x6d4

        $sequence_6 = { 4157 4881ec68020000 488b05???????? 4833c4 4889842440020000 49896b18 }
            // n = 6, score = 100
            //   4157                 | mov                 dword ptr [ebp - 0x10], eax
            //   4881ec68020000       | dec                 eax
            //   488b05????????       |                     
            //   4833c4               | lea                 edx, [0xc40c]
            //   4889842440020000     | mov                 eax, 5
            //   49896b18             | dec                 eax

        $sequence_7 = { 4883c308 488d0520990100 483bd8 75d8 b001 4883c420 }
            // n = 6, score = 100
            //   4883c308             | mov                 dword ptr [eax - 0x30], ebp
            //   488d0520990100       | inc                 esp
            //   483bd8               | mov                 esp, ebp
            //   75d8                 | dec                 esp
            //   b001                 | mov                 dword ptr [eax - 0x38], esi
            //   4883c420             | inc                 esp

        $sequence_8 = { ff15???????? 3d24040000 7523 eb1c 41c70601000000 4885ed 7410 }
            // n = 7, score = 100
            //   ff15????????         |                     
            //   3d24040000           | lea                 eax, [edx + 4]
            //   7523                 | dec                 eax
            //   eb1c                 | mov                 ecx, ebx
            //   41c70601000000       | mov                 ecx, ebp
            //   4885ed               | inc                 esp
            //   7410                 | lea                 edi, [ebx + 4]

        $sequence_9 = { e9???????? 488d05b7890100 4a8b0ce8 42385cf938 }
            // n = 4, score = 100
            //   e9????????           |                     
            //   488d05b7890100       | dec                 esp
            //   4a8b0ce8             | mov                 esi, edx
            //   42385cf938           | dec                 esp

    condition:
        7 of them and filesize < 339968
}