rule win_unidentified_098_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_098."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_098"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 4c89f1 e8???????? b901000000 4989c5 e8???????? 4989c4 0fb644244f }
            // n = 7, score = 400
            //   4c89f1               | mov                 eax, dword ptr [eax + 0x20]
            //   e8????????           |                     
            //   b901000000           | dec                 ecx
            //   4989c5               | mov                 esp, ecx
            //   e8????????           |                     
            //   4989c4               | dec                 esp
            //   0fb644244f           | lea                 ebp, [esp + 0x30]

        $sequence_1 = { e9???????? 498b0424 8954244c 4c89e1 4488442440 ff5048 8b54244c }
            // n = 7, score = 400
            //   e9????????           |                     
            //   498b0424             | mov                 ebp, eax
            //   8954244c             | je                  0x96
            //   4c89e1               | dec                 eax
            //   4488442440           | mov                 ecx, eax
            //   ff5048               | dec                 eax
            //   8b54244c             | lea                 ecx, [esp + 0x5040]

        $sequence_2 = { 488945b0 488b45c8 0fb64038 3c01 7423 84c0 0f849e000000 }
            // n = 7, score = 400
            //   488945b0             | mov                 esp, ecx
            //   488b45c8             | dec                 esp
            //   0fb64038             | mov                 ecx, esp
            //   3c01                 | dec                 eax
            //   7423                 | add                 esp, 0x20
            //   84c0                 | dec                 eax
            //   0f849e000000         | sub                 esp, 0x20

        $sequence_3 = { 48397c2448 0f83b5000000 488b4310 488b5318 c644244401 4839d0 }
            // n = 6, score = 400
            //   48397c2448           | mov                 esp, eax
            //   0f83b5000000         | inc                 ecx
            //   488b4310             | mov                 byte ptr [esp + 0x10], dl
            //   488b5318             | jmp                 0x87e
            //   c644244401           | dec                 eax
            //   4839d0               | lea                 ecx, [0xe31d7]

        $sequence_4 = { 7426 662e0f1f840000000000 498b4c2408 4885c9 7446 4983c420 e8???????? }
            // n = 7, score = 400
            //   7426                 | test                al, al
            //   662e0f1f840000000000     | je    0x21dcb
            //   498b4c2408           | je                  0x5df
            //   4885c9               | dec                 eax
            //   7446                 | lea                 ecx, [0x159572]
            //   4983c420             | mov                 word ptr [esp + 0x124], 0xe093
            //   e8????????           |                     

        $sequence_5 = { 4c89f7 31c0 f3aa b903000000 c744244c04010000 4989f0 4c89f2 }
            // n = 7, score = 400
            //   4c89f7               | mov                 eax, dword ptr [esp + 0x14]
            //   31c0                 | cmp                 eax, 0xa
            //   f3aa                 | jne                 0xfffffc9e
            //   b903000000           | nop                 word ptr [eax + eax]
            //   c744244c04010000     | dec                 ecx
            //   4989f0               | mov                 eax, esi
            //   4c89f2               | dec                 eax

        $sequence_6 = { 4e8d0441 4c894220 4e8d0c49 4c894a30 41b900000080 4c39c8 7c1b }
            // n = 7, score = 400
            //   4e8d0441             | cmp                 ebp, 0x7fffffff
            //   4c894220             | dec                 esp
            //   4e8d0c49             | mov                 edx, edi
            //   4c894a30             | dec                 esp
            //   41b900000080         | mov                 ecx, esp
            //   4c39c8               | dec                 esp
            //   7c1b                 | mov                 ecx, edi

        $sequence_7 = { c744243c00000000 89442420 e8???????? b804000000 4d8d442410 488b542448 488b4c2440 }
            // n = 7, score = 400
            //   c744243c00000000     | test                al, al
            //   89442420             | je                  0x108
            //   e8????????           |                     
            //   b804000000           | dec                 eax
            //   4d8d442410           | lea                 eax, [0x1764c5]
            //   488b542448           | mov                 word ptr [esp + 0x30], 0xad4d
            //   488b4c2440           | vmovups             xmmword ptr [esp + 0x20], xmm0

        $sequence_8 = { 3c20 7407 88842f39010000 488b8ba0000000 e8???????? 4885c0 0f84a6020000 }
            // n = 7, score = 400
            //   3c20                 | ret                 
            //   7407                 | dec                 eax
            //   88842f39010000       | lea                 ecx, [0x17a437]
            //   488b8ba0000000       | test                al, al
            //   e8????????           |                     
            //   4885c0               | je                  0x6a1
            //   0f84a6020000         | dec                 eax

        $sequence_9 = { e8???????? 418b442414 83f80a 7580 0f1f00 49ff442430 49c744242800000000 }
            // n = 7, score = 400
            //   e8????????           |                     
            //   418b442414           | add                 byte ptr [eax - 0x77], cl
            //   83f80a               | inc                 esp
            //   7580                 | and                 al, 0x20
            //   0f1f00               | inc                 ebp
            //   49ff442430           | test                esi, esi
            //   49c744242800000000     | je    0x125

    condition:
        7 of them and filesize < 3345408
}