rule win_unidentified_099_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_099."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_099"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 48895c2408 4889742410 57 4883ec20 488d1d7e700100 }
            // n = 5, score = 100
            //   48895c2408           | mov                 edi, eax
            //   4889742410           | dec                 eax
            //   57                   | lea                 eax, [0xffffe3ce]
            //   4883ec20             | mov                 ecx, 0x2d
            //   488d1d7e700100       | rep stosb           byte ptr es:[edi], al

        $sequence_1 = { 498bcd ff15???????? b974000000 e8???????? 4c8bd0 }
            // n = 5, score = 100
            //   498bcd               | dec                 eax
            //   ff15????????         |                     
            //   b974000000           | mov                 ebx, ecx
            //   e8????????           |                     
            //   4c8bd0               | dec                 eax

        $sequence_2 = { 488d05fb9d0000 49c1e302 4889452f 83e202 8bc2 4903c3 4c8945ef }
            // n = 7, score = 100
            //   488d05fb9d0000       | mov                 eax, ecx
            //   49c1e302             | dec                 ecx
            //   4889452f             | add                 eax, ebx
            //   83e202               | inc                 esp
            //   8bc2                 | xor                 eax, ecx
            //   4903c3               | shl                 eax, 3
            //   4c8945ef             | dec                 eax

        $sequence_3 = { f3aa 488d8520030000 33c9 4533c9 4889442420 4533c0 ff15???????? }
            // n = 7, score = 100
            //   f3aa                 | jl                  0x28b
            //   488d8520030000       | dec                 esp
            //   33c9                 | lea                 ecx, [esp + 0x160]
            //   4533c9               | dec                 eax
            //   4889442420           | lea                 edx, [0x197a0]
            //   4533c0               | dec                 eax
            //   ff15????????         |                     

        $sequence_4 = { 4885c0 0f8421040000 4d8bc5 488d1506950100 488d4c2450 }
            // n = 5, score = 100
            //   4885c0               | lea                 ecx, [edx + 4]
            //   0f8421040000         | dec                 esp
            //   4d8bc5               | lea                 ecx, [esp + 0x68]
            //   488d1506950100       | inc                 ecx
            //   488d4c2450           | mov                 eax, 0x800

        $sequence_5 = { 7410 488d0d2cb50100 4883c428 e9???????? e8???????? 85c0 }
            // n = 6, score = 100
            //   7410                 | inc                 esp
            //   488d0d2cb50100       | mov                 dword ptr [esp + 0x20], eax
            //   4883c428             | mov                 edx, 0x40000000
            //   e9????????           |                     
            //   e8????????           |                     
            //   85c0                 | inc                 esp

        $sequence_6 = { 752c 4985df 7527 488b9540070000 4c8d0502860000 498bcd 44897604 }
            // n = 7, score = 100
            //   752c                 | dec                 eax
            //   4985df               | sub                 esp, 0x740
            //   7527                 | dec                 eax
            //   488b9540070000       | xor                 eax, esp
            //   4c8d0502860000       | dec                 eax
            //   498bcd               | mov                 dword ptr [ebp + 0x630], eax
            //   44897604             | inc                 ecx

        $sequence_7 = { 41b880000000 e8???????? 4533ed 488d8d50040000 33d2 44896c2468 }
            // n = 6, score = 100
            //   41b880000000         | sub                 ecx, eax
            //   e8????????           |                     
            //   4533ed               | dec                 eax
            //   488d8d50040000       | lea                 edi, [0xfffedaec]
            //   33d2                 | dec                 eax
            //   44896c2468           | mov                 ecx, edi

        $sequence_8 = { 488d8c2490200000 4533c9 48897c2430 897c2428 ba00000080 c744242003000000 }
            // n = 6, score = 100
            //   488d8c2490200000     | lea                 ecx, [0x187ce]
            //   4533c9               | rep stosb           byte ptr es:[edi], al
            //   48897c2430           | dec                 eax
            //   897c2428             | mov                 ecx, eax
            //   ba00000080           | xor                 eax, eax
            //   c744242003000000     | dec                 esp

        $sequence_9 = { 488d7f01 4883fa2d 7ce7 4c8d8510020000 }
            // n = 4, score = 100
            //   488d7f01             | dec                 eax
            //   4883fa2d             | sub                 esp, 0x660
            //   7ce7                 | dec                 eax
            //   4c8d8510020000       | mov                 dword ptr [esp + 8], ebx

    condition:
        7 of them and filesize < 314368
}