rule win_unidentified_100_auto {

    meta:
        author = "Felix Bilstein - yara-signator at cocacoding dot com"
        date = "2026-01-05"
        version = "1"
        description = "Detects win.unidentified_100."
        info = "autogenerated rule brought to you by yara-signator"
        tool = "yara-signator v0.6.0"
        signator_config = "callsandjumps;datarefs;binvalue"
        malpedia_reference = "https://malpedia.caad.fkie.fraunhofer.de/details/win.unidentified_100"
        malpedia_rule_date = "20260105"
        malpedia_hash = "19b79e7cab4eaf532122e5b45a77dd8f6bb5cc79"
        malpedia_version = "20251219"
        malpedia_license = "CC BY-SA 4.0"
        malpedia_sharing = "TLP:WHITE"

    /* DISCLAIMER
     * The strings used in this rule have been automatically selected from the
     * disassembly of memory dumps and unpacked files, using YARA-Signator.
     * The code and documentation is published here:
     * https://github.com/fxb-cocacoding/yara-signator
     * As Malpedia is used as data source, please note that for a given
     * number of families, only single samples are documented.
     * This likely impacts the degree of generalization these rules will offer.
     * Take the described generation method also into consideration when you
     * apply the rules in your use cases and assign them confidence levels.
     */


    strings:
        $sequence_0 = { 0fb6442420 2580000000 88442402 0fb6442420 }
            // n = 4, score = 200
            //   0fb6442420           | dec                 eax
            //   2580000000           | imul                ecx, ecx, 2
            //   88442402             | dec                 eax
            //   0fb6442420           | mov                 edx, dword ptr [esp + 0x10]

        $sequence_1 = { 488b542420 88040a 6b05????????03 0fb60c24 03c1 4898 488b4c2420 }
            // n = 7, score = 200
            //   488b542420           | mov                 ecx, 0x26
            //   88040a               | rep movsb           byte ptr es:[edi], byte ptr [esi]
            //   6b05????????03       |                     
            //   0fb60c24             | dec                 eax
            //   03c1                 | lea                 eax, [esp + 0x6e0]
            //   4898                 | dec                 eax
            //   488b4c2420           | lea                 ecx, [0x1fbdd]

        $sequence_2 = { 8d0c8d03000000 4863c9 488b542448 4c8b442440 410fb60400 88040a }
            // n = 6, score = 200
            //   8d0c8d03000000       | dec                 ebx
            //   4863c9               | inc                 eax
            //   488b542448           | push                ebx
            //   4c8b442440           | dec                 eax
            //   410fb60400           | sub                 esp, 0x20
            //   88040a               | jmp                 0x420

        $sequence_3 = { 488d9424a0070000 488d8c24a0050000 e8???????? 8b442434 ffc0 eb3d }
            // n = 6, score = 200
            //   488d9424a0070000     | dec                 eax
            //   488d8c24a0050000     | lea                 edx, [0x140ba]
            //   e8????????           |                     
            //   8b442434             | mov                 ecx, ebx
            //   ffc0                 | mov                 ecx, 1
            //   eb3d                 | dec                 eax

        $sequence_4 = { 3da5000000 751b 48630424 488b4c2478 c6040146 48630424 }
            // n = 6, score = 200
            //   3da5000000           | lea                 eax, [esp + 0x610]
            //   751b                 | dec                 eax
            //   48630424             | lea                 ecx, [0x1fbad]
            //   488b4c2478           | dec                 eax
            //   c6040146             | mov                 edi, eax
            //   48630424             | dec                 eax

        $sequence_5 = { 488b8c24c0000000 4c8b442468 420fb60c01 e8???????? 0fb6c0 8b4c242c 33c8 }
            // n = 7, score = 200
            //   488b8c24c0000000     | dec                 esp
            //   4c8b442468           | lea                 ecx, [esp + 0x1370]
            //   420fb60c01           | dec                 esp
            //   e8????????           |                     
            //   0fb6c0               | lea                 eax, [0x1f170]
            //   8b4c242c             | mov                 edx, 0xff
            //   33c8                 | dec                 eax

        $sequence_6 = { 488bf1 b932000000 f3a4 488d842402030000 }
            // n = 4, score = 200
            //   488bf1               | dec                 eax
            //   b932000000           | sub                 esp, 0x28
            //   f3a4                 | dec                 eax
            //   488d842402030000     | lea                 ecx, [0x1bc11]

        $sequence_7 = { 488b8c24c0000000 4c8b842480000000 420fb60c01 e8???????? 0fb6c0 8b4c2438 33c8 }
            // n = 7, score = 200
            //   488b8c24c0000000     | jne                 0x342
            //   4c8b842480000000     | dec                 eax
            //   420fb60c01           | lea                 edx, [esp + 0xd20]
            //   e8????????           |                     
            //   0fb6c0               | dec                 eax
            //   8b4c2438             | lea                 ecx, [esp + 0xac0]
            //   33c8                 | mov                 eax, dword ptr [esp + 0xe0]

        $sequence_8 = { 742d 4c8d4c2460 41b802000000 488d542464 488b4c2448 ff15???????? 8b442460 }
            // n = 7, score = 200
            //   742d                 | dec                 eax
            //   4c8d4c2460           | arpl                cx, cx
            //   41b802000000         | dec                 eax
            //   488d542464           | mov                 edx, dword ptr [esp + 0x48]
            //   488b4c2448           | dec                 esp
            //   ff15????????         |                     
            //   8b442460             | mov                 eax, dword ptr [esp + 0x40]

        $sequence_9 = { c744841001000000 e9???????? 48630424 488b4c2470 0fb60401 83f82b 751e }
            // n = 7, score = 200
            //   c744841001000000     | mov                 eax, dword ptr [ebx + edx*8]
            //   e9????????           |                     
            //   48630424             | inc                 edx
            //   488b4c2470           | cmp                 byte ptr [eax + esi*8 + 0x38], dh
            //   0fb60401             | jge                 0x1a96
            //   83f82b               | cmp                 byte ptr [esp + 0xa0], 2
            //   751e                 | add                 edi, dword ptr [esp + 0xb8]

    condition:
        7 of them and filesize < 372736
}